<?php
/**
 * RSS2 Feed Template for displaying RSS2 Posts feed.
 * Forked from WordPress Core - feed-rss2.php.
 *
 * @package WordPress
 */

header( 'Content-Type: ' . feed_content_type( 'rss2' ) . '; charset=' . get_option( 'blog_charset' ), true );
$more = 1;

echo '<?xml version="1.0" encoding="' . get_option( 'blog_charset' ) . '"?' . '>';

/**
 * Filter to remove Podcast feed credit.
 *
 * @param boolean Defaults to false.
 */
if ( ! apply_filters( 'rank_math/podcast/remove_credit', false ) ) {
	echo "\n<!-- This Podcast feed is generated by Rank Math PRO SEO plugin - rankmath.com -->\n";
}

/**
 * Fires between the xml and rss tags in a feed.
 *
 * @param string $context Type of feed. Possible values include 'rss2', 'rss2-comments',
 *                        'rdf', 'atom', and 'atom-comments'.
 */
do_action( 'rss_tag_pre', 'rss2' );
?>
<rss version="2.0"
	xmlns:content="http://purl.org/rss/1.0/modules/content/"
	xmlns:wfw="http://wellformedweb.org/CommentAPI/"
	xmlns:dc="http://purl.org/dc/elements/1.1/"
	xmlns:atom="http://www.w3.org/2005/Atom"
	xmlns:sy="http://purl.org/rss/1.0/modules/syndication/"
	xmlns:slash="http://purl.org/rss/1.0/modules/slash/"
	<?php
	/**
	 * Fires at the end of the RSS root to add namespaces.
	 */
	do_action( 'rss2_ns' );
	do_action( 'rss2_podcast_ns' );
	?>
>
	<channel>
		<title><?php wp_title_rss(); ?></title>
		<atom:link href="<?php self_link(); ?>" rel="self" type="application/rss+xml" />
		<link><?php bloginfo_rss( 'url' ); ?></link>
		<description><?php bloginfo_rss( 'description' ); ?></description>
		<lastBuildDate><?php echo get_feed_build_date( 'r' ); ?></lastBuildDate>
		<language><?php bloginfo_rss( 'language' ); ?></language>
		<sy:updatePeriod>
		<?php
			$duration = 'hourly';

			/**
			 * Filters how often to update the RSS feed.
			 *
			 * @param string $duration The update period. Accepts 'hourly', 'daily', 'weekly', 'monthly',
			 *                         'yearly'. Default 'hourly'.
			 */
			echo apply_filters( 'rss_update_period', $duration );
		?>
		</sy:updatePeriod>
		<sy:updateFrequency>
		<?php
			$frequency = '1';

			/**
			 * Filters the RSS update frequency.
			 *
			 * @param string $frequency An integer passed as a string representing the frequency
			 *                          of RSS updates within the update period. Default '1'.
			 */
			echo apply_filters( 'rss_update_frequency', $frequency );
		?>
		</sy:updateFrequency>
		<?php
		/**
		 * Fires at the end of the RSS2 Feed Header.
		 */
		do_action( 'rss2_head' );
		do_action( 'rss2_podcast_head' );

		while ( have_posts() ) :
			the_post();

			if ( ! get_post_meta( get_the_ID(), 'rank_math_schema_PodcastEpisode', true ) ) {
				continue;
			}
			?>
		<item>
			<title><?php the_title_rss(); ?></title>
			<link><?php the_permalink_rss(); ?></link>
			<?php if ( get_comments_number() || comments_open() ) : ?>
				<comments><?php comments_link_feed(); ?></comments>
			<?php endif; ?>

			<dc:creator><![CDATA[<?php the_author(); ?>]]></dc:creator>
			<pubDate><?php echo mysql2date( 'D, d M Y H:i:s +0000', get_post_time( 'Y-m-d H:i:s', true ), false ); ?></pubDate>
			<?php the_category_rss( 'rss2' ); ?>
			<guid isPermaLink="false"><?php the_guid(); ?></guid>

			<?php if ( get_option( 'rss_use_excerpt' ) ) : ?>
				<description><![CDATA[<?php the_excerpt(); ?>]]></description>
			<?php else : ?>
				<description><![CDATA[<?php the_excerpt(); ?>]]></description>
				<?php
					$content = apply_filters( 'the_content', get_the_content() );
					$content = str_replace( ']]>', ']]&gt;', $content );
				?>
				<?php if ( strlen( $content ) > 0 ) : ?>
					<content:encoded><![CDATA[<?php echo $content; ?>]]></content:encoded>
				<?php else : ?>
					<content:encoded><![CDATA[<?php the_excerpt(); ?>]]></content:encoded>
				<?php endif; ?>
			<?php endif; ?>

			<?php if ( get_comments_number() || comments_open() ) : ?>
				<wfw:commentRss><?php echo esc_url( get_post_comments_feed_link( null, 'rss2' ) ); ?></wfw:commentRss>
				<slash:comments><?php echo get_comments_number(); ?></slash:comments>
			<?php endif; ?>

			<?php rss_enclosure(); ?>

			<?php
			/**
			 * Fires at the end of each RSS2 feed item.
			 */
			do_action( 'rss2_item' );
			do_action( 'rss2_podcast_item' );
			?>
		</item>
		<?php endwhile; ?>
	</channel>
</rss>
