"use strict";

jQuery(window).on('elementor/frontend/init', function () {
	
	// Gallery Slider Widget
	elementorFrontend.hooks.addAction('frontend/element_ready/photomentor-gallery-slider.default', function ($scope) {
		var slider_container = $scope.find('.photomentor_slider_wrapper'),
			photomentor_sliders = [];
		
		slider_container.each(function () {
			var $this = jQuery(this),
				this_id = $this.attr('data-id');
			photomentor_sliders[this_id] = {};
			var this_obj = photomentor_sliders[this_id];
			
			this_obj.id = $this.attr('data-id');
			this_obj.obj = $this;
			this_obj.slides_inner = $this.find('.photomentor_slider_slide_inner');
			this_obj.active_slide = 0;
			this_obj.options = {
				autoplay: $this.attr('data-autoplay'),
				speed: $this.attr('data-interval'),
				thumbs: $this.attr('data-thumbs'),
				max: $this.find('.photomentor_slider_slide').length,
			};
			this_obj.interval = setInterval(function(){
				this_obj.move.call(this_obj,1)
			}, this_obj.options.speed);
			
			this_obj.init = function() {
				var $this_obj_in = this;
				$this_obj_in.setup(this,'');
				if ($this_obj_in.active_slide == 0)
					$this_obj_in.goto.call(this,1);
				
				// Touch and Click Events
				$this_obj_in.obj.on("swipeleft", function () {
					$this_obj_in.move.call($this_obj_in,1);
				});
				$this_obj_in.obj.on("swipeup", function () {
					$this_obj_in.move.call($this_obj_in,1);
				});
				$this_obj_in.obj.on("swiperight", function () {
					$this_obj_in.move.call($this_obj_in,-1);
				});
				$this_obj_in.obj.on("swipedown", function () {
					$this_obj_in.move.call($this_obj_in,-1);
				});
				
				$this_obj_in.obj.find('.photomentor_slider_btn_prev').on('click', function(){
					$this_obj_in.move.call($this_obj_in,-1);
				});
				$this_obj_in.obj.find('.photomentor_slider_btn_next').on('click', function(){
					$this_obj_in.move.call($this_obj_in,1);
				});
				
				// Window Events
				if (jQuery('.elementor-editor-active').size() > 0) {
					$this_obj_in.obj.removeClass('photomentor_module_loading');
				}
				
				jQuery(window).on('load', function(){
					$this_obj_in.obj.removeClass('photomentor_module_loading');
					$this_obj_in.setup.call($this_obj_in,'');
				});
				jQuery(window).on('resize', function(){
					$this_obj_in.setup.call($this_obj_in,'');
				});
			};
			
			this_obj.setup = function(action) {
				var $this_obj_in = this;
				switch (action) {
					default:
						if ($this_obj_in.options.thumbs == 'on') {
							var	$photomentor_slider_thumbs = this.obj.find('.photomentor_slider_thumbs'),
								$photomentor_slider_thumbs_inner = $photomentor_slider_thumbs.find('.photomentor_slider_thumbs_inner');
							
							$photomentor_slider_thumbs_inner.removeClass('centered_thumbs');
							if ($photomentor_slider_thumbs_inner.height() < $photomentor_slider_thumbs.height()) {
								$photomentor_slider_thumbs_inner.addClass('centered_thumbs');
							}
						}
						if (jQuery('.photomentor_single_gallery_wrapper').length) {
							var this_height = jQuery(window).height(),
								this_top = 0;
							
							if (jQuery('#wpadminbar').length) {
								this_height = this_height - jQuery('#wpadminbar').height();
								this_top = jQuery('#wpadminbar').height();
							}
							if ($this_obj_in.obj.attr('data-header') == 'yes') {
								this_height = this_height - photomentor_header.height();
								this_top = this_top + photomentor_header.height();
							}
							if ($this_obj_in.obj.attr('data-footer') == 'yes') {
								this_height = this_height - photomentor_footer.height();
							}
							$this_obj_in.obj.height(this_height).css('top', this_top + 'px');
							
							$this_obj_in.slides_inner.width(this.obj.width()).height(this.obj.height());
							
							if (photomentor_footer.length) {
								photomentor_footer.css({
									'position' : 'fixed',
									'left' : '0px',
									'bottom' : '0px',
									'width' : '100%',
								});
							}
						} else {
							if ($this_obj_in.obj.hasClass('auto_height')) {
								var $this_column_wrap = $this_obj_in.obj.parents('.elementor-column-wrap'),
									this_height = $this_obj_in.obj.parents('section.elementor-element').children('.elementor-container').height() - parseInt($this_column_wrap.css('padding-top'),10) - parseInt($this_column_wrap.css('padding-bottom'),10);
								$this_obj_in.obj.height(this_height);
								
							} else if ($this_obj_in.obj.hasClass('screen_height')) {
								var this_height = jQuery(window).height();
								if (jQuery('#wpadminbar').size() > 0) {
									this_height = this_height - jQuery('#wpadminbar').height();
								}
								
								if ($this_obj_in.obj.hasClass('exclude_class')) {
									if ($this_obj_in.obj.attr('data-classes') !== '') {
										var ex_classes_array = $this_obj_in.obj.attr('data-classes').split(",");
										jQuery.each(ex_classes_array, function(index,value) {
											this_height = this_height - jQuery(value).height();
										});
									}
								}
								if ($this_obj_in.obj.hasClass('exclude_height')) {
									if ($this_obj_in.obj.attr('data-rheight') !== '') {
										this_height = this_height - parseInt($this_obj_in.obj.attr('data-rheight'),10);
									}
								}

								this_height = Math.ceil(this_height);
								$this_obj_in.obj.height(this_height);
							}
							$this_obj_in.slides_inner.width($this_obj_in.obj.width()).height($this_obj_in.obj.height());
						}
				}
			};
			
			this_obj.check = function(check_id) {
				var $this_obj_in = this;
				check_id = parseInt(check_id,10);
				if (check_id < 1)
					check_id = $this_obj_in.options.max;
				if (check_id > $this_obj_in.options.max)
					check_id = 1;
				return check_id;
			};
			
			this_obj.move = function(dir) {
				var $this_obj_in = this;
				var this_obj = this;
				$this_obj_in.obj.removeClass('move_bck');
				$this_obj_in.obj.removeClass('move_frw');
				if (dir > 0) {
					$this_obj_in.active_slide++;
					$this_obj_in.obj.addClass('move_frw');
				}
				if (dir < 0) {
					$this_obj_in.active_slide--;
					$this_obj_in.obj.addClass('move_bck');
				}
				$this_obj_in.active_slide = $this_obj_in.check.call($this_obj_in, $this_obj_in.active_slide);
				setTimeout(function(){
					this_obj.update.call(this_obj,this_obj.active_slide);
				},100);
			};
			
			this_obj.update = function(active) {
				var $this_obj_in = this;
				clearInterval($this_obj_in.interval);
				
				var photomentor_slides = $this_obj_in.obj.find('.photomentor_slider_slide'),
					photomentor_slides_inner = $this_obj_in.obj.find('.photomentor_slider_slide_inner'),
					this_active = $this_obj_in.obj.find('[data-count='+ active +']'),
					prev_id = active - 1,
					next_id = active + 1;
				
				prev_id = $this_obj_in.check.call($this_obj_in, prev_id);
				next_id = $this_obj_in.check.call($this_obj_in, next_id);
				
				photomentor_slides.removeClass('prev');
				photomentor_slides.removeClass('active');
				photomentor_slides.removeClass('next');
				
				
				$this_obj_in.obj.find('[data-count='+ prev_id +']').addClass('prev');
				this_active.addClass('active');
				$this_obj_in.obj.find('[data-count='+ next_id +']').addClass('next');
				
				if (!$this.hasClass('pause_on_hover') || ($this.hasClass('pause_on_hover') && !$this.hasClass('photomentor_kbd_activated'))) {
					if ($this_obj_in.options.autoplay == 'on') {
						$this_obj_in.interval = setInterval(function(){
							$this_obj_in.move.call($this_obj_in,1)
						}, $this_obj_in.options.speed);
					}
				}
			};
			
			this_obj.goto = function(slide) {
				var $this_obj_in = this;
				$this_obj_in.active_slide = slide;
				
				if ($this_obj_in.active_slide < 1)
					$this_obj_in.active_slide = $this_obj_in.options.max;
				if ($this_obj_in.active_slide > $this_obj_in.options.max)
					$this_obj_in.active_slide = 1;
				
				$this_obj_in.update.call($this_obj_in,$this_obj_in.active_slide);
			};
			
			var $this = jQuery(this),
				this_id = $this.attr('data-id'),
				this_obj = photomentor_sliders[this_id];
			this_obj.init.apply(this_obj);
		});
		
		slider_container.on('mouseover', function(){
			var $this = jQuery(this),
				this_id = $this.attr('data-id'),
				this_obj = photomentor_sliders[this_id];
			
			$this.addClass('photomentor_kbd_activated');
			if ($this.hasClass('pause_on_hover') && $this.attr('data-autoplay') == 'on') {
				clearInterval(this_obj.interval);
			}
		});
		
		slider_container.on('mouseleave', function(){
			var $this = jQuery(this),
				this_id = $this.attr('data-id'),
				this_obj = photomentor_sliders[this_id];
			
			$this.removeClass('photomentor_kbd_activated');
			if ($this.hasClass('pause_on_hover') && $this.attr('data-autoplay') == 'on') {
				this_obj.interval = setInterval(function(){
					this_obj.move.call(this_obj,1)
				}, this_obj.options.speed);
			}
		});
		
		jQuery(document.documentElement).keyup(function (event) {
			if (slider_container.length == 1) {
				var this_id = slider_container.attr('data-id'),
					this_obj = photomentor_sliders[this_id];
				if ((event.keyCode == 37 || event.keyCode == 38)) {
					event.preventDefault();
					this_obj.move.call(this_obj,-1);
				}
				if ((event.keyCode == 39 || event.keyCode == 40)) {
					event.preventDefault();
					this_obj.move.call(this_obj,1);
				}
			} else if (jQuery('.photomentor_kbd_activated').length) {
				var this_id = jQuery('.photomentor_kbd_activated').attr('data-id'),
					this_obj = photomentor_sliders[this_id];
				if ((event.keyCode == 37 || event.keyCode == 38)) {
					event.preventDefault();
					this_obj.move.call(this_obj,-1);
				}
				if ((event.keyCode == 39 || event.keyCode == 40)) {
					event.preventDefault();
					this_obj.move.call(this_obj,1);
				}
			}
		});
	});
	
	// Gallery Slider with Content Widget
	elementorFrontend.hooks.addAction('frontend/element_ready/photomentor-gallery-slider-content.default', function ($scope) {
		var slider_container = $scope.find('.photomentor_slider_wrapper'),
			photomentor_sliders = [];
		
		slider_container.each(function () {
			var $this = jQuery(this),
				this_id = $this.attr('data-id');
			photomentor_sliders[this_id] = {};
			var this_obj = photomentor_sliders[this_id];
			
			this_obj.id = $this.attr('data-id');
			this_obj.obj = $this;
			this_obj.slides_inner = $this.find('.photomentor_slider_slide_inner');
			this_obj.active_slide = 0;
			this_obj.options = {
				autoplay: $this.attr('data-autoplay'),
				speed: $this.attr('data-interval'),
				thumbs: $this.attr('data-thumbs'),
				max: $this.find('.photomentor_slider_slide').length,
			};
			this_obj.interval = setInterval(function(){
				this_obj.move.call(this_obj,1)
			}, this_obj.options.speed);
			
			this_obj.init = function() {
				var $this_obj_in = this;
				$this_obj_in.setup(this,'');
				if ($this_obj_in.active_slide == 0)
					$this_obj_in.goto.call(this,1);
				
				// Touch and Click Events
				$this_obj_in.obj.on("swipeleft", function () {
					$this_obj_in.move.call($this_obj_in,1);
				});
				$this_obj_in.obj.on("swipeup", function () {
					$this_obj_in.move.call($this_obj_in,1);
				});
				$this_obj_in.obj.on("swiperight", function () {
					$this_obj_in.move.call($this_obj_in,-1);
				});
				$this_obj_in.obj.on("swipedown", function () {
					$this_obj_in.move.call($this_obj_in,-1);
				});
				
				$this_obj_in.obj.find('.photomentor_slider_btn_prev').on('click', function(){
					$this_obj_in.move.call($this_obj_in,-1);
				});
				$this_obj_in.obj.find('.photomentor_slider_btn_next').on('click', function(){
					$this_obj_in.move.call($this_obj_in,1);
				});
				
				// Window Events
				if (jQuery('.elementor-editor-active').size() > 0) {
					$this_obj_in.obj.removeClass('photomentor_module_loading');
				}
				
				jQuery(window).on('load', function(){
					$this_obj_in.obj.removeClass('photomentor_module_loading');
					$this_obj_in.setup.call($this_obj_in,'');
				});
				jQuery(window).on('resize', function(){
					$this_obj_in.setup.call($this_obj_in,'');
				});
			};
			
			this_obj.setup = function(action) {
				var $this_obj_in = this;
				switch (action) {
					default:
						if ($this_obj_in.options.thumbs == 'on') {
							var	$photomentor_slider_thumbs = this.obj.find('.photomentor_slider_thumbs'),
								$photomentor_slider_thumbs_inner = $photomentor_slider_thumbs.find('.photomentor_slider_thumbs_inner');
							
							$photomentor_slider_thumbs_inner.removeClass('centered_thumbs');
							if ($photomentor_slider_thumbs_inner.height() < $photomentor_slider_thumbs.height()) {
								$photomentor_slider_thumbs_inner.addClass('centered_thumbs');
							}
						}
						if (jQuery('.photomentor_single_gallery_wrapper').length) {
							var this_height = jQuery(window).height(),
								this_top = 0;
							
							if (jQuery('#wpadminbar').length) {
								this_height = this_height - jQuery('#wpadminbar').height();
								this_top = jQuery('#wpadminbar').height();
							}
							if ($this_obj_in.obj.attr('data-header') == 'yes') {
								this_height = this_height - photomentor_header.height();
								this_top = this_top + photomentor_header.height();
							}
							if ($this_obj_in.obj.attr('data-footer') == 'yes') {
								this_height = this_height - photomentor_footer.height();
							}
							$this_obj_in.obj.height(this_height).css('top', this_top + 'px');
							
							$this_obj_in.slides_inner.width(this.obj.width()).height(this.obj.height());
							
							if (photomentor_footer.length) {
								photomentor_footer.css({
									'position' : 'fixed',
									'left' : '0px',
									'bottom' : '0px',
									'width' : '100%',
								});
							}
						} else {
							if ($this_obj_in.obj.hasClass('auto_height')) {
								var $this_column_wrap = $this_obj_in.obj.parents('.elementor-column-wrap'),
									this_height = $this_obj_in.obj.parents('section.elementor-element').children('.elementor-container').height() - parseInt($this_column_wrap.css('padding-top'),10) - parseInt($this_column_wrap.css('padding-bottom'),10);
								$this_obj_in.obj.height(this_height);
								
							} else if ($this_obj_in.obj.hasClass('screen_height')) {
								var this_height = jQuery(window).height();
								if (jQuery('#wpadminbar').size() > 0) {
									this_height = this_height - jQuery('#wpadminbar').height();
								}
								
								if ($this_obj_in.obj.hasClass('exclude_class')) {
									if ($this_obj_in.obj.attr('data-classes') !== '') {
										var ex_classes_array = $this_obj_in.obj.attr('data-classes').split(",");
										jQuery.each(ex_classes_array, function(index,value) {
											this_height = this_height - jQuery(value).height();
										});
									}
								}
								if ($this_obj_in.obj.hasClass('exclude_height')) {
									if ($this_obj_in.obj.attr('data-rheight') !== '') {
										this_height = this_height - parseInt($this_obj_in.obj.attr('data-rheight'),10);
									}
								}

								this_height = Math.ceil(this_height);
								$this_obj_in.obj.height(this_height);
							}
							$this_obj_in.slides_inner.width($this_obj_in.obj.width()).height($this_obj_in.obj.height());
						}
				}
			};
			
			this_obj.check = function(check_id) {
				var $this_obj_in = this;
				check_id = parseInt(check_id,10);
				if (check_id < 1)
					check_id = $this_obj_in.options.max;
				if (check_id > $this_obj_in.options.max)
					check_id = 1;
				return check_id;
			};
			
			this_obj.move = function(dir) {
				var $this_obj_in = this;
				var this_obj = this;
				$this_obj_in.obj.removeClass('move_bck');
				$this_obj_in.obj.removeClass('move_frw');
				if (dir > 0) {
					$this_obj_in.active_slide++;
					$this_obj_in.obj.addClass('move_frw');
				}
				if (dir < 0) {
					$this_obj_in.active_slide--;
					$this_obj_in.obj.addClass('move_bck');
				}
				$this_obj_in.active_slide = $this_obj_in.check.call($this_obj_in, $this_obj_in.active_slide);
				setTimeout(function(){
					this_obj.update.call(this_obj,this_obj.active_slide);
				},100);
			};
			
			this_obj.update = function(active) {
				var $this_obj_in = this;
				clearInterval($this_obj_in.interval);
				
				var photomentor_slides = $this_obj_in.obj.find('.photomentor_slider_slide'),
					photomentor_slides_inner = $this_obj_in.obj.find('.photomentor_slider_slide_inner'),
					this_active = $this_obj_in.obj.find('[data-count='+ active +']'),
					prev_id = active - 1,
					next_id = active + 1;
				
				prev_id = $this_obj_in.check.call($this_obj_in, prev_id);
				next_id = $this_obj_in.check.call($this_obj_in, next_id);
				
				photomentor_slides.removeClass('prev');
				photomentor_slides.removeClass('active');
				photomentor_slides.removeClass('next');
				
				
				$this_obj_in.obj.find('[data-count='+ prev_id +']').addClass('prev');
				this_active.addClass('active');
				$this_obj_in.obj.find('[data-count='+ next_id +']').addClass('next');
				
				if (!$this.hasClass('pause_on_hover') || ($this.hasClass('pause_on_hover') && !$this.hasClass('photomentor_kbd_activated'))) {
					if ($this_obj_in.options.autoplay == 'on') {
						$this_obj_in.interval = setInterval(function(){
							$this_obj_in.move.call($this_obj_in,1)
						}, $this_obj_in.options.speed);
					}
				}
			};
			
			this_obj.goto = function(slide) {
				var $this_obj_in = this;
				$this_obj_in.active_slide = slide;
				
				if ($this_obj_in.active_slide < 1)
					$this_obj_in.active_slide = $this_obj_in.options.max;
				if ($this_obj_in.active_slide > $this_obj_in.options.max)
					$this_obj_in.active_slide = 1;
				
				$this_obj_in.update.call($this_obj_in,$this_obj_in.active_slide);
			};
			
			var $this = jQuery(this),
				this_id = $this.attr('data-id'),
				this_obj = photomentor_sliders[this_id];
			this_obj.init.apply(this_obj);
		});
		
		slider_container.on('mouseover', function(){
			var $this = jQuery(this),
				this_id = $this.attr('data-id'),
				this_obj = photomentor_sliders[this_id];
			
			$this.addClass('photomentor_kbd_activated');
			if ($this.hasClass('pause_on_hover') && $this.attr('data-autoplay') == 'on') {
				clearInterval(this_obj.interval);
			}
		});
		
		slider_container.on('mouseleave', function(){
			var $this = jQuery(this),
				this_id = $this.attr('data-id'),
				this_obj = photomentor_sliders[this_id];
			
			$this.removeClass('photomentor_kbd_activated');
			if ($this.hasClass('pause_on_hover') && $this.attr('data-autoplay') == 'on') {
				this_obj.interval = setInterval(function(){
					this_obj.move.call(this_obj,1)
				}, this_obj.options.speed);
			}
		});
		
		jQuery(document.documentElement).keyup(function (event) {
			if (slider_container.length == 1) {
				var this_id = slider_container.attr('data-id'),
					this_obj = photomentor_sliders[this_id];
				if ((event.keyCode == 37 || event.keyCode == 38)) {
					event.preventDefault();
					this_obj.move.call(this_obj,-1);
				}
				if ((event.keyCode == 39 || event.keyCode == 40)) {
					event.preventDefault();
					this_obj.move.call(this_obj,1);
				}
			} else if (jQuery('.photomentor_kbd_activated').length) {
				var this_id = jQuery('.photomentor_kbd_activated').attr('data-id'),
					this_obj = photomentor_sliders[this_id];
				if ((event.keyCode == 37 || event.keyCode == 38)) {
					event.preventDefault();
					this_obj.move.call(this_obj,-1);
				}
				if ((event.keyCode == 39 || event.keyCode == 40)) {
					event.preventDefault();
					this_obj.move.call(this_obj,1);
				}
			}
		});
		
		var bg_grad = $scope.find('.photomentor_js_bg_gradient'),
			bg_color = $scope.find('.photomentor_js_bg_color');
		
		if (bg_grad.length) {
			bg_grad.each(function () {
				jQuery(this).css('background-image', jQuery(this).attr('data-bggrad'));
			});
		}
		
		if (bg_color.length) {
			bg_color.each(function () {
				jQuery(this).css('background-color', jQuery(this).attr('data-bgcolor'));
			});
		}
	});
});