"use strict";

jQuery(window).on('elementor/frontend/init', function () {
	elementorFrontend.hooks.addAction('frontend/element_ready/photomentor-gallery-portrait-slider.default', function ($scope) {
		var container = $scope.find('.photomentor_gallery_portrait'),
			window_width = jQuery(window).width(),
			transition_type = container.attr('data-transition'),
			height_type = container.attr('data-height-type'),
			window_height = jQuery(window).height(),
			custom_height = container.attr('data-height');
		
		if (window_width > 737) {
			if (height_type === 'auto') {
				if (jQuery('body').hasClass('customize-support')) {
					container.height(window_height - 32);
				} else {
					container.height(window_height);
				}
			} else {
				container.height(custom_height);
			}
		}
		
		if (transition_type === 'fade') {
			photomentor_portrait_fade(container);
		}
		
		if (transition_type === 'slide') {
			photomentor_portrait_slide(container);
		}
		
		jQuery(window).on('resize', function () {
			window_height = jQuery(window).height();
			
			if (window_width > 737) {
				if (height_type === 'auto') {
					if (jQuery('body').hasClass('customize-support')) {
						container.height(window_height - 32);
					} else {
						container.height(window_height);
					}
				}
			}
			
			if (transition_type === 'slide') {
				photomentor_portrait_slide_resize(container);
				
				setTimeout(function (container) {
					photomentor_portrait_slide_resize(container);
				}, 300, container);
				
				setTimeout(function (container) {
					photomentor_portrait_slide_resize(container);
				}, 500, container);
				
				setTimeout(function (container) {
					photomentor_portrait_slide_resize(container);
				}, 700, container);
			}
		});
	});
});

function photomentor_portrait_fade(container) {
	var elements = jQuery(container).children(),
		number_of_elements = elements.length,
		slide_item = jQuery(container).find('li'),
		next_button = jQuery(container).find('.photomentor_slider_btn_next'),
		prev_button = jQuery(container).find('.photomentor_slider_btn_prev');
	
	slide_item.first().addClass('visible_slide');
	
	// Autoplay
	var autoplay_status = container.attr('data-autoplay'),
		slider_speed = container.attr('data-speed'),
		pause_status = container.attr('data-pause'),
		intervalID;
	
	if (autoplay_status === 'on') {
		intervalID = setInterval(function (container) {
			photomentor_next_slide_fade(container);
		}, slider_speed, container);
		
		if (pause_status === 'on') {
			container.on({
				mouseenter: function () {
					clearInterval(intervalID);
				},
				
				mouseleave: function () {
					intervalID = setInterval(function (container) {
						photomentor_next_slide_fade(container);
					}, slider_speed, container);
				}
			});
		}
	}
	
	// Navigation
	next_button.on('click', function(){
		photomentor_next_slide_fade(container);
	});
	
	prev_button.on('click', function(){
		photomentor_prev_slide_fade(container);
	});
	
	
	// Next Slide
	function photomentor_next_slide_fade(container) {
		var sliderList = jQuery(container).find('.photomentor_gallery.effect_fade'),
			number_of_elements = container.attr('data-slides-number'),
			slide_item = jQuery(container).find('li'),
			current_item = jQuery(container).find('.visible_slide'),
			slide_number = current_item.attr('data-number');
		
		// alert(number_of_elements);
		
		if (slide_number < number_of_elements) {
			sliderList.find('.visible_slide').removeClass('visible_slide').next().addClass('visible_slide');
		} else {
			sliderList.find('.visible_slide').removeClass('visible_slide');
			slide_item.first().addClass('visible_slide');
		}
	}
	
	// Previous Slide
	function photomentor_prev_slide_fade(container) {
		var number_of_elements = container.attr('data-slides-number'),
			slide_item = jQuery(container).find('li'),
			current_item = jQuery(container).find('.visible_slide'),
			slide_number = current_item.attr('data-number');
		
		if (slide_number === '1') {
			jQuery(container).find('.visible_slide').removeClass('visible_slide');
			slide_item.last().addClass('visible_slide');
		} else {
			jQuery(container).find('.visible_slide').removeClass('visible_slide').prev().addClass('visible_slide');
		}
	}
}

function photomentor_portrait_slide(container) {
	var sliderList = jQuery(container).find('.photomentor_gallery'),
		increment = jQuery(sliderList).children().outerWidth(true),
		elmnts = jQuery(sliderList).children(),
		numElmts = container.attr('data-slides-number'),
		sizeFirstElmnt = increment,
		shownInViewport = Math.round(container.width() / sizeFirstElmnt),
		firstElementOnViewPort = 1,
		isAnimating = false,
		slide_item = jQuery(sliderList).find('li'),
		next_button = jQuery(container).find('.photomentor_slider_btn_next'),
		prev_button = jQuery(container).find('.photomentor_slider_btn_prev');
	
	slide_item.width(container.width());
	
	var i;
	for (i = 0; i < (shownInViewport); i++) {
		jQuery(sliderList).css('width',(numElmts+shownInViewport)*increment + increment + 'px');
		jQuery(sliderList).append(jQuery(elmnts[i]).clone().addClass('cloned_slide'));
	}
	
	slide_item.first().addClass('visible_slide');
	
	// Autoplay
	var autoplay_status = container.attr('data-autoplay'),
		slider_speed = container.attr('data-speed'),
		pause_status = container.attr('data-pause'),
		intervalID;
	
	if (jQuery('.elementor-editor-active').size() < 1) {
		if (autoplay_status === 'on') {
			intervalID = setInterval(function (container) {
				photomentor_next_slide_slide(container);
			}, slider_speed, container);
			
			if (pause_status === 'on') {
				container.on({
					mouseenter: function () {
						clearInterval(intervalID);
					},
					
					mouseleave: function () {
						intervalID = setInterval(function (container) {
							photomentor_next_slide_slide(container);
						}, slider_speed, con);
					}
				});
			}
		}
	}
	
	// Navigation
	next_button.on('click', function(){
		photomentor_next_slide_slide(container);
	});
	
	prev_button.on('click', function(){
		photomentor_prev_slide_slide(container);
	});
	
	// Next Slide
	function photomentor_next_slide_slide(container) {
		var elements = jQuery(container).find('.photomentor_gallery').children(),
			increment = elements.outerWidth(true),
			number_of_elements = elements.length - 1,
			slide_item = jQuery(container).find('li'),
			current_item = jQuery(container).find('.visible_slide'),
			slide_number = current_item.attr('data-number');
		
		if (!isAnimating) {
			if (firstElementOnViewPort > numElmts) {
				firstElementOnViewPort = 2;
				jQuery(sliderList).css('left', '0px');
			}
			else {
				firstElementOnViewPort++;
			}
			jQuery(sliderList).animate({
				left: '-=' + increment,
				y: 0,
				queue: true
			}, 'swing', function(){isAnimating = false;});
			isAnimating = true;
		}
		
		// Current Slide
		if (slide_number < number_of_elements) {
			jQuery(container).find('li.visible_slide').removeClass('visible_slide').next().addClass('visible_slide');
		} else {
			jQuery(container).find('li.visible_slide').removeClass('visible_slide');
			jQuery(slide_item).first().addClass('visible_slide');
		}
	}
	
	// Previous Slide
	function photomentor_prev_slide_slide(container) {
		var elements = jQuery(container).find('.photomentor_gallery').children(),
			increment = elements.outerWidth(true),
			number_of_elements = elements.length - 1,
			slide_item = jQuery(container).find('li'),
			current_item = jQuery(container).find('.visible_slide'),
			slide_number = current_item.attr('data-number');
		
		sizeFirstElmnt = increment;
		
		if (!isAnimating) {
			if (firstElementOnViewPort === 1) {
				jQuery(sliderList).css('left', '-' + numElmts * sizeFirstElmnt + 'px');
				firstElementOnViewPort = numElmts;
			}
			else {
				firstElementOnViewPort--;
			}
			
			jQuery(sliderList).animate({
				left: '+=' + increment,
				y: 0,
				queue: true
			}, 'swing', function(){isAnimating = false;});
			isAnimating = true;
		}
		
		// Current Slide
		if (slide_number === '1') {
			jQuery(container).find('li.visible_slide').removeClass('visible_slide');
			jQuery(container).find('[data-number=' + number_of_elements + ']').addClass('visible_slide');
		} else {
			jQuery(container).find('li.visible_slide').removeClass('visible_slide').prev().addClass('visible_slide');
		}
	}
}

function photomentor_portrait_slide_resize(container) {
	var sliderList = jQuery(container).find('.photomentor_gallery'),
		increment = jQuery(sliderList).children().outerWidth(true),
		numElmts = container.attr('data-slides-number'),
		sizeFirstElmnt = increment,
		shownInViewport = Math.round(container.width() / sizeFirstElmnt),
		slide_item = jQuery(sliderList).find('li'),
		current_element = parseInt(jQuery(sliderList).find('.visible_slide').attr('data-number'), 10),
		left_increment = increment * (current_element - 1),
		i;
	
	slide_item.width(container.width());
	sliderList.css('left', -left_increment + 'px');
	
	for (i = 0; i < (shownInViewport); i++) {
		jQuery(sliderList).css('width',(numElmts+shownInViewport)*increment + increment + 'px');
	}
}
