"use strict";

var photomentor_kenburns = [];
var $photomentor_css_kenburns = jQuery('.photomentor_css_kenburns');

jQuery(window).on('elementor/frontend/init', function () {
	elementorFrontend.hooks.addAction('frontend/element_ready/photomentor-gallery-kenburns.default', function ($scope) {
		$scope.find('.photomentor_css_kenburns ').each(function () {
            var $this = jQuery(this),
                this_id = $this.attr('data-id');

            photomentor_kenburns['photomentor_kenburns_'+this_id] = {};
            var $this_obj = photomentor_kenburns['photomentor_kenburns_'+this_id];

            $this_obj.id = this_id;
            $this_obj.obj = $this;
            $this_obj.active_slide = 0;
            $this_obj.max = $this.find('.photomentor_css_kenburns_slide').length;
            $this_obj.time = $this.attr('data-time');
            $this_obj.slide_time = parseInt($this.attr('data-time'),10) + parseInt($this.attr('data-fade'),10);
            $this_obj.zoom = $this.attr('data-zoom');
            $this_obj.fade = $this.attr('data-fade');

            $this_obj.setup = function(action) {
                var $this_obj_in = $this_obj;
                if (jQuery('.photomentor_css_kenburns_single').length) {
                    var setHeight = photomentor_window.height(),
                        setTop = 0;
                    $this_obj_in.obj.height(setHeight).css('top', setTop+'px');
                } else {
                    if ($this_obj_in.obj.hasClass('auto_height')) {
                        var setHeight = $this_obj_in.obj.parents('section.elementor-element').children('.elementor-container').height() - parseInt($this_obj_in.obj.parents('.elementor-column-wrap').css('padding-top'),10) - parseInt($this_obj_in.obj.parents('.elementor-column-wrap').css('padding-bottom'),10);
                        $this_obj_in.obj.height(setHeight);
                    }

                    if ($this_obj_in.obj.hasClass('screen_height')) {
                        var setHeight = jQuery(window).height();
                        if (jQuery('#wpadminbar').length && !$this_obj_in.obj.hasClass('photomentor_page_kenburns')) {
                            setHeight = setHeight - jQuery('#wpadminbar').height();
                        }
                        $this_obj_in.obj.height(setHeight);
                    }
                }
            };

            $this_obj.move = function(dir) {
                var $this_obj_in = $this_obj;
                if (dir > 0)
                    $this_obj_in.active_slide++;
                if (dir < 0)
                    $this_obj_in.active_slide--;

                $this_obj_in.active_slide = $this_obj_in.check.call($this_obj_in, $this_obj_in.active_slide);
                $this_obj_in.update.call($this_obj_in,$this_obj_in.active_slide);
            };

            $this_obj.check = function(check_id) {
                var $this_obj_in = this;
                check_id = parseInt(check_id,10);
                if (check_id < 1)
                    check_id = $this_obj_in.max;
                if (check_id > $this_obj_in.max)
                    check_id = 1;
                return check_id;
            };

            $this_obj.update = function(active) {
                var $this_obj_in = $this_obj;
                clearInterval($this_obj_in.interval);

                $this_obj_in.next_slide = $this_obj_in.active_slide + 1;
                $this_obj_in.prev_slide = $this_obj_in.active_slide - 1;

                $this_obj_in.prev_slide = $this_obj_in.check.call($this_obj_in, $this_obj_in.prev_slide);
                $this_obj_in.next_slide = $this_obj_in.check.call($this_obj_in, $this_obj_in.next_slide);

                var photomentor_slides = $this_obj_in.obj.find('.photomentor_css_kenburns_slide'),
                    this_active = $this_obj_in.obj.find('[data-count='+ active +']'),
                    this_prev = $this_obj_in.obj.find('[data-count='+ $this_obj_in.prev_slide +']'),
                    this_next = $this_obj_in.obj.find('[data-count='+ $this_obj_in.next_slide +']');


                photomentor_slides.removeClass('active');
                photomentor_slides.removeClass('prev_slide');
                photomentor_slides.removeClass('next_slide');

                this_prev.addClass('prev_slide');
                this_active.addClass('active');
                this_next.addClass('next_slide');

                $this_obj_in.interval = setInterval(function() {
                    $this_obj_in.move.call($this_obj_in,1);
                }, $this_obj_in.time);
            };

            $this_obj.goto = function(slide) {
                var $this_obj_in = $this_obj;
                $this_obj_in.active_slide = slide;

                if ($this_obj_in.active_slide < 1)
                    $this_obj_in.active_slide = $this_obj_in.max;
                if ($this_obj_in.active_slide > $this_obj_in.max)
                    $this_obj_in.active_slide = 1;

                $this_obj_in.update.call($this_obj_in,$this_obj_in.active_slide);
            };

            // Init
            $this_obj.interval = setInterval(function() {
                $this_obj.move.call($this_obj,1);
            }, $this_obj.time);

            $this_obj.obj.after('\
                <style>\
                    .photomentor_css_kenburns'+ $this_obj.id +' .photomentor_css_kenburns_slide {\
                        transition: transform '+ $this_obj.slide_time +'ms ease-in-out, opacity '+ $this_obj.fade +'ms;\
                    }\
                    .photomentor_css_kenburns'+ $this_obj.id +' .slide_zoom_out {\
                        transform: scale('+ $this_obj.zoom +');\
                    }\
                    .photomentor_css_kenburns'+ $this_obj.id +' .photomentor_css_kenburns_slide.prev_slide.slide_zoom_in,\
                    .photomentor_css_kenburns'+ $this_obj.id +' .photomentor_css_kenburns_slide.active.slide_zoom_in {\
                        transform: scale('+ $this_obj.zoom +');\
                    }\
                </style>\
            ');

            $this_obj.setup($this_obj,'');
            if ($this_obj.active_slide == 0)
                $this_obj.goto.call($this_obj,1);

            // Window Events
            jQuery(window).on('load', function(){
                $this_obj.obj.removeClass('photomentor_module_loading');
                $this_obj.setup.call($this_obj,'');
            });
            jQuery(window).on('resize', function(){
                $this_obj.setup.call($this_obj,'');
            });
		});
	});
});