"use strict";

jQuery(window).on('elementor/frontend/init', function () {
	elementorFrontend.hooks.addAction('frontend/element_ready/photomentor-gallery-justified.default', function ($scope) {
		$scope.find('.photomentor_justified_wrapper').each(function () {
			if (jQuery('div').is('.photomentor_justified_gallery')) {
				jQuery('.photomentor_justified_gallery').each(function(){
					var $this = jQuery(this),
						setpad = $this.attr('data-setpad'),
						rowheight = $this.attr('data-rowheight'),
						lastRow = $this.attr('data-lastRow');
					$this.justifiedGallery({
						rowHeight : rowheight,
						lastRow : lastRow,
						margins : setpad
					});
				});
			}
			
			var photomentor_justified_array = [];
			var $this_obj = jQuery(this);
			photomentor_justified_array["photomentor_justified_" + $this_obj.attr('data-uniqid')] = {};
			var this_array = photomentor_justified_array["photomentor_justified_" + $this_obj.attr('data-uniqid')];
			this_array.id = jQuery(this).attr('data-uniqid');
			this_array.showed = 0;
			this_array.items = [];
			
			var this_items_array = this_array.items;
			if ($this_obj.find('.photomentor_justified_gallery_array').length) {
				$this_obj.find('.photomentor_justified_gallery_array').each(function() {
					jQuery(this).find('.photomentor_justified_array_item').each(function() {
						var $this = jQuery(this),
							photomentor_justified_item = {};
						photomentor_justified_item.slide_type = $this.attr('data-type');
						photomentor_justified_item.img = $this.attr('data-img');
						photomentor_justified_item.thmb = $this.attr('data-thmb');
						photomentor_justified_item.title = $this.attr('data-title');
                        photomentor_justified_item.capt = $this.attr('data-caption');
						photomentor_justified_item.alt = $this.attr('data-alt');
						photomentor_justified_item.overlay = $this.attr('data-overlay');
						photomentor_justified_item.counter = $this.attr('data-counter');
						photomentor_justified_item.size = $this.attr('data-size');
						this_items_array.push(photomentor_justified_item);
					});
					//jQuery(this).remove();
				});
			}
			
			this_array.obj = jQuery('.photomentor_justified_wrapper'+this_array.id);
			
			this_array.init = function () {
				var this_obj = this;
				this.obj.find('.justified_load_more').on("click", function () {
					this_obj.loadmore.call(this_obj);
				});
				this.setup.call(this);
				this.preloader.call(this);
			};
			
			this_array.preloader = function() {
				var this_obj = this,
					$this_dom = this.obj;
				if ($this_dom.find('.load_anim_grid:first').size() > 0) {
					(function (img, src) {
						img.src = src;
						img.onload = function () {
							$this_dom.find('.load_anim_grid:first').removeClass('load_anim_grid').removeClass('anim_el').animate({
								'z-index': '15'
							}, 50, function() {
								this_obj.setup.call(this_obj);
								this_obj.preloader.call(this_obj);
							});
						};
					}(new Image(), $this_dom.find('.load_anim_grid:first').find('img').attr('src')));
				} else {
					var $button = $this_dom.find('.justified_load_more');
					$button.removeClass('photomentor_ajax_query_posts_disabled');
					if ($button.hasClass('lazy_loading')) {
						$button.removeClass('loading');
						photomentor_check_lazy($button);
					}
					
					this_obj.setup.call(this_obj);
				}
			};
			
			this_array.setup = function() {
				var this_obj = this,
					$this_dom = this.obj,
					$photomentor_dp = $this_dom.find('.photomentor_dp');
				if (jQuery('body').hasClass('photomentor_drag_protection')) {
					$photomentor_dp.on('mousedown',function(e){
						e.preventDefault();
					});
				}
				if ($this_dom.find('.photomentor_js_bg_color').length) {
					$this_dom.find('.photomentor_js_bg_color').each(function () {
						jQuery(this).css('background-color', jQuery(this).attr('data-bgcolor'));
					});
				}
				$this_dom.find('.photomentor_justified_item').each(function(){
					if (jQuery(this).hasClass('anim_el2')) {
						jQuery(this).removeClass('anim_el2');
					}
				});
			};
			
			this_array.loadmore = function() {
				var this_obj = this,
					$this_dom = this.obj,
					photomentor_what_to_append = '',
					photomentor_grid_post_per_page = $this_dom.attr('data-perload'),
					photomentor_uniqid = this.id,
					photomentor_allposts = this.items.length,
					photomentor_count = $this_dom.find('.photomentor_justified_item').size(),
					photomentor_ins_container = $this_dom.find('.photomentor_justified_gallery'),
					photomentor_load_more_button = $this_dom.find('.justified_load_more');
				
				if (this.showed >= photomentor_allposts) {
					// alert('Action');
					if ($this_dom.hasClass('demo_mode')) {
						this_obj.showed = 0;
						this_obj.loadmore.call(this_obj);
					} else {
						photomentor_load_more_button.slideUp(300);
					}
				} else {
					var photomentor_now_step = this.showed + parseInt(photomentor_grid_post_per_page) - 1;
					if ((photomentor_now_step + 1) < photomentor_allposts) {
						var photomentor_limit = photomentor_now_step;
					} else {
						var photomentor_limit = photomentor_allposts - 1;
						if ($this_dom.hasClass('demo_mode')) {
							this_obj.showed = 0;
						} else {
							photomentor_load_more_button.slideUp(300);
						}
					}
					
					$this_dom.find('.justified_load_more').addClass('loading');
					
					for (var i = this.showed; i <= photomentor_limit; i++) {
						var photomentor_thishref = this.items[i].img,
							photomentor_what_to_append = photomentor_what_to_append +'\
			                <a class="photomentor_pswp_slide photomentor_justified_item photomentor_dp photomentor_no_select anim_el anim_el2 load_anim_grid grid_b2p" href="' + photomentor_thishref +'" data-elementor-open-lightbox="no" data-size="'+ this.items[i].size +'" data-count="'+ photomentor_count +'" data-caption="'+ this.items[i].capt +'">\
			                    <img alt="' + this.items[i].alt + '" src="'+ this.items[i].thmb +'"/>\
			                    <div class="grid-item-content">\
			                        <h6>'+ this.items[i].title +'</h6>\
			                    </div>\
			                    <div class="grid-item-overlay"></div>\
			                </a>';
						photomentor_count++;
						
						// PSWP React
						if (this.items[i].slide_type == 'video') {
							if(photomentor_thishref.indexOf('youtu') + 1) {
								//YT Video
								var videoid_split = photomentor_thishref.split('='),
									videoid = videoid_split[1],
									photomentor_pswp_html = '<div class="photomentor_pswp_video_wrapper"><iframe width="100%" height="100%" src="https://www.youtube.com/embed/' + videoid + '?controls=1&autoplay=0&showinfo=0&modestbranding=1&wmode=opaque&rel=0&hd=1&disablekb=1" frameborder="0" allowfullscreen></iframe></div>';
							}
							if(photomentor_thishref.indexOf('vimeo') + 1) {
								//Vimeo Video
								var videoid_split = photomentor_thishref.split('m/'),
									videoid = videoid_split[1],
									photomentor_pswp_html = '<div class="photomentor_pswp_video_wrapper"><iframe width="100%" height="100%" src="https://player.vimeo.com/video/' + videoid + '?api=1&amp;title=0&amp;byline=0&amp;portrait=0&autoplay=0&loop=0&controls=1" frameborder="0" webkitAllowFullScreen allowFullScreen></iframe></div>';
							}
							var this_item = {
								html : photomentor_pswp_html
							};
							$pswp_gallery_array['photomentor_gallery_' + photomentor_uniqid].slides.push(this_item);
						} else {
							var item_size = this.items[i].size.split('x'),
								item_width = item_size[0],
								item_height = item_size[1],
								this_item = {
									src : photomentor_thishref,
									w : item_width,
									h : item_height,
                                    title: this.items[i].capt
								};
							$pswp_gallery_array['photomentor_gallery_' + photomentor_uniqid].slides.push(this_item);
						}
						
						this.showed++;
					}
					
					photomentor_ins_container.append(photomentor_what_to_append);
					photomentor_ins_container.justifiedGallery('norewind');
					
					this_obj.setup.call(this_obj);
					this_obj.preloader.call(this_obj);
				}
			};
			
			if (jQuery('.lazy_loading').length) {
				var $this = $scope.find('.lazy_loading'),
					win_scroll = jQuery(window).scrollTop(),
					this_offset = $this.offset().top,
					check_val = jQuery(window).height()*2 + win_scroll;
				
				if (check_val > this_offset && !$this.hasClass('loading')) {
					$this.click();
				}
				
				jQuery(window).on('scroll', function() {
					var $this = $scope.find('.lazy_loading'),
						win_scroll = jQuery(window).scrollTop(),
						this_offset = $this.offset().top,
						check_val = jQuery(window).height()*2 + win_scroll;
					
					if (check_val > this_offset  && !$this.hasClass('loading')) {
						$this.click();
					}
				});
			}
			
			var $this_obj = jQuery(this),
				this_obj = photomentor_justified_array["photomentor_justified_" + $this_obj.attr('data-uniqid')];
			this_obj.init.call(this_obj);
			
			jQuery(window).on('scroll', function () {
				$scope.find('.test').click();
			});
		});
	});
});
