<?php
/*
 * Created by Pixel-Mafia
 * www.pixel-mafia.com
*/

namespace Photomentor\Core\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Photomentor_Gallery_Slider_Widget extends Widget_Base {
	
	public function get_name() {
		return 'photomentor-gallery-slider';
	}
	
	public function get_title() {
		return esc_html__('Gallery Slider', 'photomentor');
	}
	
	public function get_icon() {
		return 'eicon-slideshow';
	}
	
	public function get_categories() {
		return ['photomentor_gallery_widgets'];
	}
	
	public function get_script_depends() {
		return ['gallery_slider'];
	}
	
	protected function _register_controls() {
		// ----------------------------- //
		// ---------- Content ---------- //
		// ----------------------------- //
		$this->start_controls_section(
			'section_gallery',
			[
				'label' => esc_html__('Gallery', 'photomentor')
			]
		);
		
		$this->add_control(
			'images',
			[
				'label' => esc_html__( 'Add Images', 'photomentor' ),
				'type' => Controls_Manager::GALLERY,
				'default' => [],
			]
		);
		
		$this->add_control(
			'control_divider_0',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);
		
		$this->add_control(
			'fit_style',
			[
				'label' => esc_html__('Fit Style', 'photomentor'),
				'type' => Controls_Manager::SELECT,
				'default' => 'cover',
				'options' => [
					'cover' => esc_html__('Cover Slide', 'photomentor'),
					'fit_always' => esc_html__('Fit Always', 'photomentor'),
					'fit_width' => esc_html__('Fit Width', 'photomentor'),
					'fit_height' => esc_html__('Fit Height', 'photomentor')
				]
			]
		);
		
		$this->add_control(
			'control_divider_1',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);
		
		$this->add_control(
			'module_height_state',
			[
				'label' => esc_html__('Module Height Type', 'photomentor'),
				'type' => Controls_Manager::SELECT,
				'default' => 'screen_height',
				'options' => [
					'auto' => esc_html__('Auto', 'photomentor'),
					'screen_height' => esc_html__('Screen Height', 'photomentor'),
					'custom' => esc_html__('Custom', 'photomentor')
				]
			]
		);
		
		$this->add_control(
			'control_divider_1x',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'module_height_state' => 'screen_height'
				]
			]
		);

		$this->add_control(
			'exclude_class',
			[
				'label' => esc_html__('Reduce Height By Classes', 'photomentor'),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'no',
				'label_off' => esc_html__('No', 'photomentor'),
				'label_on' => esc_html__('Yes', 'photomentor'),
				'condition' => [
					'module_height_state' => 'screen_height'
				]
			]
		);

		$this->add_control(
			'control_divider_1ec',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'module_height_state' => 'screen_height',
					'exclude_class' => 'yes'
				]
			]
		);

		$this->add_control(
			'reduce_classes',
			[
				'label' => esc_html__('Classes to Exclude (separate by commas)', 'photomentor'),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => '',
				'condition' => [
					'module_height_state' => 'screen_height',
					'exclude_class' => 'yes'
				]
			]
		);

		$this->add_control(
			'control_divider_1ecx',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'module_height_state' => 'screen_height',
				]
			]
		);

		$this->add_control(
			'exclude_height',
			[
				'label' => esc_html__('Reduce Height in PX', 'photomentor'),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'no',
				'label_off' => esc_html__('No', 'photomentor'),
				'label_on' => esc_html__('Yes', 'photomentor'),
				'condition' => [
					'module_height_state' => 'screen_height'
				]
			]
		);

		$this->add_control(
			'control_divider_1eh',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'module_height_state' => 'screen_height',
					'exclude_height' => 'yes'
				]
			]
		);

		$this->add_control(
			'reduce_height',
			[
				'label' => esc_html__('Height to Reduce, PX', 'photomentor'),
				'type' => Controls_Manager::NUMBER,
				'default' => 0,
				'min' => 0,
				'step' => 1,
				'condition' => [
					'module_height_state' => 'screen_height',
					'exclude_height' => 'yes'
				]
			]
		);

		$this->add_control(
			'control_divider_2',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'module_height_state' => 'custom'
				]
			]
		);
	
		$this->add_responsive_control(
			'module_height',
			[
				'label' => esc_html__('Module Height', 'photomentor'),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 750,
					'unit' => 'px'
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 2000
					]
				],
				'condition' => [
					'module_height_state' => 'custom'
				],
				'selectors' => [
					'{{WRAPPER}} .photomentor_slider_wrapper_custom_height' => 'height: {{SIZE}}{{UNIT}};'
				]
			]
		);
		
		$this->add_control(
			'control_divider_5',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);
		
		$this->add_control(
			'fx_type',
			[
				'label' => esc_html__('Animation Style', 'photomentor'),
				'type' => Controls_Manager::SELECT,
				'default' => 'fade',
				'options' => [
					'fade' => esc_attr__('Fade', 'photomentor'),
					'fade_zoom' => esc_attr__('Fade with Zoom', 'photomentor'),
					'slip' => esc_attr__('Slide', 'photomentor'),
					'slip_zoom' => esc_attr__('Slide with Zoom', 'photomentor')
				]
			]
		);
		
		$this->add_control(
			'control_divider_6',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'autoplay',
			[
				'label' => esc_html__('Autoplay', 'photomentor'),
				'type' => Controls_Manager::SELECT,
				'default' => 'on',
				'options' => [
					'off' => esc_html__('Off', 'photomentor'),
					'on' => esc_html__('On', 'photomentor')
				]
			]
		);
		
		$this->add_control(
			'control_divider_7',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'autoplay' => 'on'
				]
			]
		);
		
		$this->add_control(
			'autoplay_speed',
			[
				'label' => esc_html__('Autoplay Speed', 'photomentor'),
				'type' => Controls_Manager::NUMBER,
				'default' => 4000,
				'min' => 0,
				'step' => 100,
				'condition' => [
					'autoplay' => 'on'
				]
			]
		);
		
		$this->end_controls_section();
		
		// -------------------------------------- //
		// ---------- Gallery Settings ---------- //
		// -------------------------------------- //
		$this->start_controls_section(
			'section_gallery_settings',
			[
				'label' => esc_html__('Gallery Settings', 'photomentor'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_control(
			'titles_state',
			[
				'label' => esc_html__('Caption', 'photomentor'),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'label_off' => esc_html__('No', 'photomentor'),
				'label_on' => esc_html__('Yes', 'photomentor')
			]
		);
		
		$this->add_control(
			'control_divider_9',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'titles_state' => 'yes'
				]
			]
		);
		
		$this->add_control(
			'title_align',
			[
				'label' => esc_html__('Caption Alignment', 'photomentor'),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'photomentor' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'photomentor' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'photomentor' ),
						'icon' => 'eicon-text-align-right',
					]
				],
				'default' => 'center',
				'selectors' => [
					'{{WRAPPER}} .photomentor_slide_title' => 'text-align: {{VALUE}};'
				],
				'condition' => [
					'titles_state' => 'yes'
				]
			]
		);
		
		$this->add_control(
			'control_divider_10',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'titles_state' => 'yes'
				]
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => esc_html__('Caption Typography', 'photomentor'),
				'selector' => '{{WRAPPER}} .photomentor_slide_title',
				'condition' => [
					'titles_state' => 'yes'
				]
			]
		);
		
		$this->add_control(
			'control_divider_11',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'titles_state' => 'yes'
				]
			]
		);
		
		$this->add_control(
			'title_color',
			[
				'label' => esc_html__('Caption Color', 'photomentor'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .photomentor_slide_title' => 'color: {{VALUE}};'
				],
				'condition' => [
					'titles_state' => 'yes'
				]
			]
		);
		
		$this->add_control(
			'control_divider_12',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);
		
		$this->add_control(
			'overlay_state',
			[
				'label' => esc_html__('Overlay', 'photomentor'),
				'type' => Controls_Manager::SELECT,
				'default' => 'on',
				'options' => [
					'on' => esc_html__('On', 'photomentor'),
					'off' => esc_html__('Off', 'photomentor'),
					'custom' => esc_html__('Custom', 'photomentor')
				]
			]
		);
		
		$this->add_control(
			'control_divider_13',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'overlay_state' => 'custom'
				]
			]
		);
		
		$this->add_control(
			'overlay_color',
			[
				'label' => esc_html__( 'Overlay Color', 'photomentor' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .photomentor_slider_custom_overlay' => 'background-color: {{VALUE}};'
				],
				'condition' => [
					'overlay_state' => 'custom'
				]
			]
		);
		
		$this->add_control(
			'control_divider_14',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);
		
		$this->add_control(
			'slider_bg_color',
			[
				'label' => esc_html__('Slides Background Color', 'photomentor'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .photomentor_slider_slide_inner' => 'background-color: {{VALUE}} !important;'
				]
			]
		);
		
		$this->end_controls_section();
        
		// -------------------------------------- //
		// ---------- Controls Settings ---------- //
		// -------------------------------------- //
		$this->start_controls_section(
			'section_controls_settings',
			[
				'label' => esc_html__('Controls Settings', 'photomentor'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'controls_state',
			[
				'label' => esc_html__('Slider Controls', 'photomentor'),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'label_off' => esc_html__('No', 'photomentor'),
				'label_on' => esc_html__('Yes', 'photomentor'),
                'prefix_class' => 'photomentor_slider_controls_',
			]
		);
		
		$this->add_control(
			'controls_style_divider',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'controls_state' => 'yes'
				]
			]
		);

		$this->add_responsive_control(
			'controls_size',
			[
				'label' => esc_html__('Size', 'photomentor'),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 20,
					'unit' => 'px'
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100
					]
				],
				'condition' => [
					'controls_state' => 'yes'
				],
				'selectors' => [
					'{{WRAPPER}} a.photomentor_slider_control i' => 'font-size: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}}; width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};'
				]
			]
		);

		$this->add_control(
			'controls_padding',
			[
				'label' => esc_html__('Padding', 'photomentor'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px'],
				'selectors' => [
					'{{WRAPPER}} a.photomentor_slider_control' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				],
				'condition' => [
					'controls_state' => 'yes'
				],
				'separator' => 'before'
			]
		);
		
		$this->add_responsive_control(
			'controls_margin',
			[
				'label' => esc_html__('Spacing', 'photomentor'),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 20,
					'unit' => 'px'
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100
					]
				],
				'condition' => [
					'controls_state' => 'yes'
				],
                'separator' => 'before',
				'selectors' => [
					'{{WRAPPER}} a.photomentor_slider_control.photomentor_slider_btn_prev' => 'left: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} a.photomentor_slider_control.photomentor_slider_btn_next' => 'right: {{SIZE}}{{UNIT}};'
				]
			]
		);

		$this->start_controls_tabs('more_button_settings_tabs');
	
            // ------ Tab Normal ------ //
            $this->start_controls_tab(
                'tab_control_normal',
                [
                    'label' => esc_html__('Normal', 'photomentor'),
                    'condition' => [
                        'controls_state' => 'yes'
                    ]
                ]
            );

                $this->add_control(
                    'controls_color',
                    [
                        'label' => esc_html__('Color', 'photomentor'),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} a.photomentor_slider_control' => 'color: {{VALUE}};'
                        ],
                        'separator' => 'before',
                        'condition' => [
                            'controls_state' => 'yes'
                        ]
                    ]
                );

                $this->add_control(
                    'controls_bg',
                    [
                        'label' => esc_html__('Background', 'photomentor'),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} a.photomentor_slider_control' => 'background-color: {{VALUE}};'
                        ],
                        'separator' => 'before',
                        'condition' => [
                            'controls_state' => 'yes'
                        ]
                    ]
                );

            $this->end_controls_tab();

            // ------ Tab Hover ------ //
            $this->start_controls_tab(
                'tab_controls_hover',
                [
                    'label' => esc_html__('Hover', 'photomentor'),
                    'condition' => [
                        'controls_state' => 'yes'
                    ]
                ]
            );

                $this->add_control(
                    'controls_color_hover',
                    [
                        'label' => esc_html__('Color', 'photomentor'),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} a.photomentor_slider_control:hover' => 'color: {{VALUE}};'
                        ],
                        'separator' => 'before',
                        'condition' => [
                            'controls_state' => 'yes'
                        ]
                    ]
                );
        
                $this->add_control(
                    'controls_bg_hover',
                    [
                        'label' => esc_html__('Background', 'photomentor'),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} a.photomentor_slider_control:hover' => 'background-color: {{VALUE}};'
                        ],
                        'separator' => 'before',
                        'condition' => [
                            'controls_state' => 'yes'
                        ]
                    ]
                );

            $this->end_controls_tab();
		
		$this->end_controls_tabs();

		$this->add_control(
			'controls_border_radius',
			[
				'label' => esc_html__('Border Radius', 'photomentor'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px','%'],
				'selectors' => [
					'{{WRAPPER}} a.photomentor_slider_control' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				],
				'condition' => [
					'controls_state' => 'yes'
				],
				'separator' => 'before'
			]
		);

		$this->end_controls_section();
	}
	
	protected function render() {
		$settings = $this->get_settings();
		
		$images = $settings['images'];
		$fit_style = $settings['fit_style'];
		$module_height_state = $settings['module_height_state'];
		$fx_type = $settings['fx_type'];
		$autoplay = $settings['autoplay'];
		$autoplay_speed = $settings['autoplay_speed'];
		$titles_state = $settings['titles_state'];
		$overlay_state = $settings['overlay_state'];
		$controls_state = $settings['controls_state'];
		//$controls_style = $settings['controls_style'];
		
		$uniqid = $this->get_id();
		
		$additional_class = '';
		
		$exclude_class = $settings['exclude_class'];
		$reduce_classes = $settings['reduce_classes'];
		$exclude_height = $settings['exclude_height'];
		$reduce_height = $settings['reduce_height'];
		
		if ($exclude_class == 'yes') {
			$additional_class = $additional_class . ' exclude_class';
		}
		if ($exclude_height == 'yes') {
			$additional_class = $additional_class . ' exclude_height';
		}
		
		// ------------------------------------ //
		// ---------- Widget Content ---------- //
		// ------------------------------------ //
		if (empty($images)) {
			return;
		}
		?>
		
		<div class="photomentor_gallery_slider_container">
				<?php
				if ($module_height_state == 'auto') {
				?>
			<div class="photomentor_slider_wrapper photomentor_no_select photomentor_module_loading auto_height" data-autoplay = "<?php echo esc_attr($autoplay); ?>" data-interval = "<?php echo esc_attr($autoplay_speed); ?>" data-id="<?php echo esc_attr($uniqid); ?>">
				<?php
				}
			
				else if ($module_height_state == 'screen_height') {
				?>
			<div class="photomentor_slider_wrapper photomentor_no_select photomentor_module_loading screen_height <?php echo esc_attr($additional_class); ?>" data-autoplay = "<?php echo esc_attr($autoplay); ?>" data-interval = "<?php echo esc_attr($autoplay_speed); ?>" data-id="<?php echo esc_attr($uniqid); ?>" data-classes = "<?php echo esc_attr($reduce_classes); ?>" data-rheight = "<?php echo esc_attr($reduce_height); ?>">
				<?php
				}
				
				else {
				?>
			<div class="photomentor_slider_wrapper photomentor_slider_wrapper_custom_height photomentor_no_select photomentor_module_loading" data-autoplay = "<?php echo esc_attr($autoplay); ?>" data-interval = "<?php echo esc_attr($autoplay_speed); ?>" data-id="<?php echo esc_attr($uniqid); ?>">
					<?php
				}
				?>
				<div class="photomentor_slider <?php echo esc_attr($fit_style); ?> photomentor_slider_<?php echo esc_attr($fx_type); ?>"
				     data-autoplay = "<?php echo esc_attr($autoplay); ?>"
				     data-interval = "<?php echo esc_attr($autoplay_speed); ?>"
				>
					<?php
					$count = 0;
					
					foreach ( $images as $index => $image ) {
						$count++;
						$photoCaption = '';
						$attach_meta = photomentor_get_attachment($image['id']);
						$photoTitle = $attach_meta['caption'];
						$photoCaption = $attach_meta['description'];
						$photoAlt = $attach_meta['alt'];
						$PCREpattern = '/\r\n|\r|\n/u';
						$photoCaption = preg_replace($PCREpattern, '', nl2br($photoCaption));
						
						$featured_image = wp_get_attachment_url($image['id']);
						if (strlen($featured_image[0]) > 0) {
							$thumb_url = aq_resize(esc_url($featured_image), '290', '216', true, true, true);
						} else {
							$thumb_url = '';
						}
						$slide_image = wp_get_attachment_image_src($image['id'], 'original');
						?>
						<div class="photomentor_slider_slide photomentor_slide2preload photomentor_slider_slide<?php echo esc_attr($count); ?>" data-count="<?php echo esc_attr($count); ?>">
							<div class="photomentor_slider_slide_inner" style="background: url('<?php echo esc_url($slide_image[0]); ?>')">
								<?php
								if ($titles_state == 'yes') {
									?>
									<h2 class="photomentor_slide_title"><?php echo esc_html($photoTitle); ?></h2>
									<?php
								}
								if ($titles_state == 'yes' && $overlay_state == 'on') {
									?>
									<span class="photomentor_slider_overlay_gradient"></span>
									<?php
								}
								if ($overlay_state == 'custom') {
									?>
									<span class="photomentor_slider_custom_overlay"></span>
									<?php
								}
								?>
							</div><!-- .photomentor_slider_slide_inner -->
						</div><!-- .photomentor_slider_slide -->
						<?php
					}
					?>
				</div>
		
				<?php
				if ($controls_state == 'yes') {
					?>
                    <a href="<?php echo esc_js("javascript:void(0)"); ?>" class="photomentor_slider_btn_prev photomentor_slider_control"><i class="pm-icon-angle-left"></i></a>
					<a href="<?php echo esc_js("javascript:void(0)"); ?>" class="photomentor_slider_btn_next photomentor_slider_control"><i class="pm-icon-angle-right"></i></a>
					<?php
				}
				?>
			</div>
		</div>
		
		<?php
	}
	
	protected function content_template() {}
	
	public function render_plain_content() {}
}

