<?php
/*
 * Created by Pixel-Mafia
 * www.pixel-mafia.com
*/

namespace Photomentor\Core\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\REPEATER;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Photomentor_Gallery_Slider_Content_Widget extends Widget_Base {
	
	public function get_name() {
		return 'photomentor-gallery-slider-content';
	}
	
	public function get_title() {
		return esc_html__('Gallery Slider with Content', 'photomentor');
	}
	
	public function get_icon() {
		return 'eicon-post-slider';
	}
	
	public function get_categories() {
		return ['photomentor_gallery_widgets'];
	}
	
	public function get_script_depends() {
		return ['gallery_slider'];
	}
	
	protected function _register_controls() {
		
		// ----------------------------- //
		// ---------- Content ---------- //
		// ----------------------------- //
		$this->start_controls_section(
			'section_gallery',
			[
				'label' => esc_html__('Slides', 'photomentor')
			]
		);
		
		$repeater = new Repeater();
		
		$repeater->start_controls_tabs('slide_options');
		
			$repeater->start_controls_tab(
				'slide_bg_image',
				[
					'label' => esc_html__( 'Image', 'photomentor' ),
				]
			);
		
				$repeater->add_control(
					'slide_color',
					[
						'label' => esc_html__( 'Color', 'photomentor' ),
						'type' => Controls_Manager::COLOR,
						'default' => '#000000',
						'selectors' => [
							'{{WRAPPER}} .photomentor_slider_slide_inner' => 'background-color: {{VALUE}} !important;'
						]
					]
				);
				
				$repeater->add_control(
					'slide_image',
					[
						'label' => esc_html__('Image', 'photomentor'),
						'type' => Controls_Manager::MEDIA,
						'default' => [
							'url' => Utils::get_placeholder_image_src(),
						]
					]
				);
				
				$repeater->add_control(
					'custom_slide_bg',
					[
						'label' => esc_html__( 'Customize Slide', 'photomentor'),
						'type' => Controls_Manager::SWITCHER,
						'default' => '',
						'label_on' => esc_html__( 'Yes', 'photomentor' ),
						'label_off' => esc_html__( 'No', 'photomentor' ),
						'return_value' => 'yes',
					]
				);
				
				$repeater->add_control(
					'fit_style_slide',
					[
						'label' => esc_html__('Fit Style', 'photomentor'),
						'type' => Controls_Manager::SELECT,
						'default' => 'cover',
						'options' => [
							'cover' => esc_attr__('Cover', 'photomentor'),
							'fit_always' => esc_attr__('Contain', 'photomentor'),
							'fit_width' => esc_attr__('Fit Width', 'photomentor'),
							'fit_height' => esc_attr__('Fit Height', 'photomentor')
						],
						'condition' => [
							'custom_slide_bg' => 'yes'
						]
					]
				);
				
				$repeater->add_control(
					'overlay_slide',
					[
						'label' => esc_html__('Background Overlay', 'photomentor'),
						'type' => Controls_Manager::SWITCHER,
						'default' => '',
						'label_on' => esc_html__( 'Yes', 'photomentor' ),
						'label_off' => esc_html__( 'No', 'photomentor' ),
						'return_value' => 'yes',
						'condition' => [
							'custom_slide_bg' => 'yes'
						]
					]
				);
				
				$repeater->add_group_control(
					Group_Control_Background::get_type(),
					[
						'type' => 'gradient',
						'name' => 'overlay_color_slide',
						'show_label' => false,
						'types' => ['classic','gradient'],
						'fields_options' => [
							'background' => [
								'toggle' => 'true',
								'label' => 'Overlay Type',
								'default' => 'classic'
							],
							'color' => [
								'default' => 'rgba(0,0,0,0.5)',
							],
							'color_b' => [
								'default' => '',
							],
							'image' => [
								'condition' => [
									'background' => 'video'
								]
							]
						],
						'selector' => '{{WRAPPER}} .photomentor_slider_overlay_custom',
						'condition' => [
							'overlay_slide' => 'yes'
						]
					]
				);
		
			$repeater->end_controls_tab();
		
			$repeater->start_controls_tab(
				'slide_content',
				[
					'label' => esc_html__( 'Content', 'photomentor' ),
				]
			);
		
				$repeater->add_control(
					'slide_title',
					[
						'label' => esc_html__('Title', 'photomentor'),
						'type' => Controls_Manager::TEXT,
						'label_block' => true,
						'placeholder' => 'Slide Title',
						'default' => '',
					]
				);
				
				$repeater->add_control(
					'slide_description',
					[
						'label' => esc_html__('Description', 'photomentor'),
						'type' => Controls_Manager::TEXTAREA,
						'placeholder' => esc_html__('This is slide description.', 'photomentor'),
						'default' => '',
					]
				);
				
				$repeater->add_control(
					'slide_button_text',
					[
						'label' => esc_html__('Button Text', 'photomentor'),
						'type' => Controls_Manager::TEXT,
						'label_block' => true,
						'placeholder' => esc_html__('Button', 'photomentor'),
						'default' => ''
					]
				);
				
				$repeater->add_control(
					'slide_link_url',
					[
						'label' => esc_html__('Link URL', 'photomentor'),
						'type' => Controls_Manager::URL,
						'default' => [
							'url' => '',
							'is_external' => 'false',
						],
						'placeholder' => esc_html__( 'http://your-link.com', 'photomentor' )
					]
				);
		
			$repeater->end_controls_tab();
		
		$repeater->end_controls_tabs();
		
		$this->add_control(
			'slider_item',
			[
				'label' => '',
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
			]
		);
		
		$this->end_controls_section();
		
		// ------------------------------------ //
		// ---------- Slider Options ---------- //
		// ------------------------------------ //
		$this->start_controls_section(
			'section_settings',
			[
				'label' => esc_html__('Slider Options', 'photomentor'),
			]
		);
		
		$this->add_control(
			'fit_style',
			[
				'label' => esc_html__('Fit Style', 'photomentor'),
				'type' => Controls_Manager::SELECT,
				'default' => 'cover',
				'options' => [
					'cover' => esc_attr__('Cover Slide', 'photomentor'),
					'fit_always' => esc_attr__('Fit Always', 'photomentor'),
					'fit_width' => esc_attr__('Fit Width', 'photomentor'),
					'fit_height' => esc_attr__('Fit Height', 'photomentor')
				]
			]
		);
		
		$this->add_control(
			'control_divider_0',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'fx_type',
			[
				'label' => esc_html__('Animation Style', 'photomentor'),
				'type' => Controls_Manager::SELECT,
				'default' => 'fade',
				'options' => [
					'fade' => esc_attr__('Fade', 'photomentor'),
					'fade_zoom' => esc_attr__('Fade with Zoom', 'photomentor'),
					'slip' => esc_attr__('Slide', 'photomentor'),
					'slip_zoom' => esc_attr__('Slide with Zoom', 'photomentor')
				]
			]
		);
		
		$this->add_control(
			'control_divider_1',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'module_height_state',
			[
				'label' => esc_html__('Module Height Type', 'photomentor'),
				'type' => Controls_Manager::SELECT,
				'default' => 'screen_height',
				'options' => [
					'auto' => esc_html__('Auto', 'photomentor'),
					'screen_height' => esc_html__('Screen Height', 'photomentor'),
					'custom' => esc_html__('Custom', 'photomentor')
				]
			]
		);
		
		$this->add_control(
			'control_divider_1x',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'module_height_state' => 'screen_height'
				]
			]
		);

		$this->add_control(
			'exclude_class',
			[
				'label' => esc_html__('Reduce Height By Classes', 'photomentor'),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'no',
				'label_off' => esc_html__('No', 'photomentor'),
				'label_on' => esc_html__('Yes', 'photomentor'),
				'condition' => [
					'module_height_state' => 'screen_height'
				]
			]
		);

		$this->add_control(
			'control_divider_1ec',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'module_height_state' => 'screen_height',
					'exclude_class' => 'yes'
				]
			]
		);

		$this->add_control(
			'reduce_classes',
			[
				'label' => esc_html__('Classes to Exclude (separate by commas)', 'photomentor'),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => '',
				'condition' => [
					'module_height_state' => 'screen_height',
					'exclude_class' => 'yes'
				]
			]
		);

		$this->add_control(
			'control_divider_1ecx',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'module_height_state' => 'screen_height',
				]
			]
		);

		$this->add_control(
			'exclude_height',
			[
				'label' => esc_html__('Reduce Height in PX', 'photomentor'),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'no',
				'label_off' => esc_html__('No', 'photomentor'),
				'label_on' => esc_html__('Yes', 'photomentor'),
				'condition' => [
					'module_height_state' => 'screen_height'
				]
			]
		);

		$this->add_control(
			'control_divider_1eh',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'module_height_state' => 'screen_height',
					'exclude_height' => 'yes'
				]
			]
		);

		$this->add_control(
			'reduce_height',
			[
				'label' => esc_html__('Height to Reduce, PX', 'photomentor'),
				'type' => Controls_Manager::NUMBER,
				'default' => 0,
				'min' => 0,
				'step' => 1,
				'condition' => [
					'module_height_state' => 'screen_height',
					'exclude_height' => 'yes'
				]
			]
		);

		$this->add_control(
			'control_divider_3',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'module_height_state' => 'custom'
				]
			]
		);
		
		$this->add_responsive_control(
			'module_height',
			[
				'label' => esc_html__('Module Height', 'photomentor'),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 750,
					'unit' => 'px'
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 2000
					]
				],
				'condition' => [
					'module_height_state' => 'custom'
				],
				'selectors' => [
					'{{WRAPPER}} .photomentor_slider_wrapper_custom_height' => 'height: {{SIZE}}{{UNIT}};'
				]
			]
		);
		
		$this->add_control(
			'control_divider_6',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'autoplay',
			[
				'label' => esc_html__( 'Autoplay', 'photomentor'),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'label_on' => esc_html__( 'Yes', 'photomentor' ),
				'label_off' => esc_html__( 'No', 'photomentor' ),
				'return_value' => 'yes'
			]
		);
		
		$this->add_control(
			'control_divider_7',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'autoplay' => 'yes'
				]
			]
		);
		
		$this->add_control(
			'autoplay_speed',
			[
				'label' => esc_html__('Autoplay Speed', 'photomentor'),
				'type' => Controls_Manager::NUMBER,
				'default' => 4000,
				'min' => 0,
				'step' => 100,
				'condition' => [
					'autoplay' => 'yes'
				]
			]
		);
		
		$this->add_control(
			'control_divider_8',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'autoplay' => 'yes'
				]
			]
		);
		
		$this->add_control(
			'pause_on_hover',
			[
				'label' => esc_html__( 'Pause On Hover', 'photomentor'),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'label_on' => esc_html__( 'Yes', 'photomentor' ),
				'label_off' => esc_html__( 'No', 'photomentor' ),
				'return_value' => 'yes',
				'condition' => [
					'autoplay' => 'yes'
				]
			]
		);
		
		$this->end_controls_section();
		
		// -------------------------------------- //
		// ---------- Overlay Settings ---------- //
		// -------------------------------------- //
		$this->start_controls_section(
			'section_style_overlay',
			[
				'label' => esc_html__( 'Overlay Settings', 'photomentor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_control(
			'overlay',
			[
				'label' => esc_html__( 'Background Overlay', 'photomentor'),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'label_on' => esc_html__( 'Yes', 'photomentor' ),
				'label_off' => __( 'No', 'photomentor' ),
				'return_value' => 'yes'
			]
		);
		
		$this->add_control(
			'control_divider_9',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'type' => 'gradient',
				'name' => 'overlay_color',
				'show_label' => false,
				'types' => ['classic','gradient'],
				'fields_options' => [
					'background' => [
						'toggle' => 'true',
						'label' => 'Overlay Type',
						'default' => 'classic'
					],
					'color' => [
						'default' => 'rgba(0,0,0,0.5)',
					],
					'color_b' => [
						'default' => '',
					],
					'image' => [
						'condition' => [
							'background' => 'video'
						]
					]
				],
				'selector' => '{{WRAPPER}} .photomentor_slider_overlay',
				'condition' => [
					'overlay' => 'yes'
				]
			]
		);
		
		$this->end_controls_section();
		
		// -------------------------------------- //
		// ---------- Content Settings ---------- //
		// -------------------------------------- //
		$this->start_controls_section(
			'section_style_content',
			[
				'label' => esc_html__( 'Content Settings', 'photomentor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_responsive_control(
			'content_width',
			[
				'label' => esc_html__('Content Width', 'photomentor'),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'unit' => '%',
					'size' => 100,
				],
				'size_units' => ['%','px'],
				'range' => [
					'%' => [
						'min' => 0,
						'max' => 100,
					],
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .photomentor_slider_content' => 'max-width: {{SIZE}}{{UNIT}};'
				]
			]
		);
		
		$this->add_control(
			'control_divider_10',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_responsive_control(
			'content_padding',
			[
				'label' => esc_html__('Content Padding', 'photomentor'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .photomentor_slider_content_box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);
		
		$this->add_control(
			'control_divider_11',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'text_align',
			[
				'label' => esc_html__('Text Align', 'photomentor'),
				'type' => Controls_Manager::CHOOSE,
				'label_block' => false,
				'options' => [
					'left' => [
						'title' => esc_html__('Left', 'photomentor'),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__('Center', 'photomentor'),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__('Right', 'photomentor'),
						'icon' => 'eicon-text-align-right',
					],
				],
				'selectors' => [
					'{{WRAPPER}} .photomentor_slider_content' => 'text-align: {{VALUE}};',
				],
			]
		);
		
		$this->add_control(
			'control_divider_12',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'vertical_position',
			[
				'label' => esc_html__('Vertical Position', 'photomentor'),
				'type' => Controls_Manager::CHOOSE,
				'label_block' => false,
				'options' => [
					'top' => [
						'title' => esc_html__('Top', 'photomentor'),
						'icon' => 'eicon-v-align-top',
					],
					'middle' => [
						'title' => esc_html__('Middle', 'photomentor'),
						'icon' => 'eicon-v-align-middle',
					],
					'bottom' => [
						'title' => esc_html__('Bottom', 'photomentor'),
						'icon' => 'eicon-v-align-bottom',
					],
				],
				'prefix_class' => 'photomentor_slider_valign_',
			]
		);
		
		$this->add_control(
			'control_divider_13',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'horizontal_position',
			[
				'label' => esc_html__('Horizontal Position', 'photomentor'),
				'type' => Controls_Manager::CHOOSE,
				'label_block' => false,
				'options' => [
					'left' => [
						'title' => esc_html__('Left', 'photomentor'),
						'icon' => 'eicon-h-align-left',
					],
					'center' => [
						'title' => esc_html__('Center', 'photomentor'),
						'icon' => 'eicon-h-align-center',
					],
					'right' => [
						'title' => esc_html__('Right', 'photomentor'),
						'icon' => 'eicon-h-align-right',
					],
				],
				'prefix_class' => 'photomentor_slider_halign_',
			]
		);
		
		$this->end_controls_section();
		
		// ------------------------------------ //
		// ---------- Title Settings ---------- //
		// ------------------------------------ //
		$this->start_controls_section(
			'section_style_title',
			[
				'label' => esc_html__( 'Title Settings', 'photomentor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_responsive_control(
			'title_bottom_space',
			[
				'label' => esc_html__('Spacing', 'photomentor'),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .photomentor_slider_title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);
		
		$this->add_control(
			'control_divider_14',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'title_color',
			[
				'label' => esc_html__('Color', 'photomentor'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .photomentor_slider_title' => 'color: {{VALUE}};',
				],
			]
		);
		
		$this->add_control(
			'control_divider_15',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .photomentor_slider_title',
			]
		);
		
		$this->end_controls_section();
		
		// ------------------------------------------ //
		// ---------- Description Settings ---------- //
		// ------------------------------------------ //
		$this->start_controls_section(
			'section_style_description',
			[
				'label' => esc_html__( 'Description Settings', 'photomentor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_responsive_control(
			'description_bottom_space',
			[
				'label' => esc_html__('Spacing', 'photomentor'),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .photomentor_slider_description' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);
		
		$this->add_control(
			'control_divider_16',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'description_color',
			[
				'label' => esc_html__('Color', 'photomentor'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .photomentor_slider_description' => 'color: {{VALUE}};',
				],
			]
		);
		
		$this->add_control(
			'control_divider_17',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'description_typography',
				'selector' => '{{WRAPPER}} .photomentor_slider_description',
			]
		);
		
		$this->end_controls_section();
		
		// ------------------------------------- //
		// ---------- Button Settings ---------- //
		// ------------------------------------- //
		$this->start_controls_section(
			'section_style_button',
			[
				'label' => esc_html__( 'Button', 'photomentor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->start_controls_tabs('button_colors');
		
		$this->start_controls_tab(
			'button_normal',
			[
				'label' => esc_html__( 'Normal', 'photomentor' )
			]
		);
		
		$this->add_control(
			'button_color',
			[
				'label' => esc_html__('Text Color', 'photomentor'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .photomentor_slider_button' => 'color: {{VALUE}};',
				]
			]
		);
		
		$this->add_control(
			'control_divider_18',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'button_bg',
			[
				'label' => esc_html__('Background Color', 'photomentor'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .photomentor_slider_button' => 'background: {{VALUE}};',
				]
			]
		);
		
		$this->add_control(
			'control_divider_19',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'button_border',
			[
				'label' => esc_html__('Border Color', 'photomentor'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .photomentor_slider_button' => 'border-color: {{VALUE}};',
				]
			]
		);
		
		$this->end_controls_tab();
		
		$this->start_controls_tab(
			'button_hover',
			[
				'label' => esc_html__( 'Hover', 'photomentor' )
			]
		);
		
		$this->add_control(
			'button_color_hover',
			[
				'label' => esc_html__('Text Color', 'photomentor'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .photomentor_slider_button:hover' => 'color: {{VALUE}};',
				]
			]
		);
		
		$this->add_control(
			'control_divider_20',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'button_bg_hover',
			[
				'label' => esc_html__('Background Color', 'photomentor'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .photomentor_slider_button:hover' => 'background: {{VALUE}};',
				]
			]
		);
		
		$this->add_control(
			'control_divider_21',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'button_border_hover',
			[
				'label' => esc_html__('Border Color', 'photomentor'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .photomentor_slider_button:hover' => 'border-color: {{VALUE}};',
				]
			]
		);
		
		$this->end_controls_tab();
		
		$this->end_controls_tabs();

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'border_style',
				'placeholder' => '1px',
				'default' => '1px',
				'selector' => '{{WRAPPER}} .photomentor_slider_button'
			]
		);

		$this->add_control(
			'control_divider_22',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'border_radius',
			[
				'label' => esc_html__('Border Radius', 'photomentor'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['%'],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .photomentor_slider_button' => 'border-radius: {{SIZE}}{{UNIT}};'
				]
			]
		);
		
		$this->add_control(
			'control_divider_23',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'button_typography',
				'selector' => '{{WRAPPER}} .photomentor_slider_button'
			]
		);
		
		$this->add_control(
			'control_divider_24',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'button_padding',
			[
				'label' => esc_html__('Button Padding', 'photomentor'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .photomentor_slider_button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);
		
		$this->add_control(
			'control_divider_25',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'button_margin',
			[
				'label' => esc_html__('Button Margin', 'photomentor'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .photomentor_slider_button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);
		
		$this->end_controls_section();
        
		// -------------------------------------- //
		// ---------- Controls Settings ---------- //
		// -------------------------------------- //
		$this->start_controls_section(
			'section_controls_settings',
			[
				'label' => esc_html__('Controls Settings', 'photomentor'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'controls_state',
			[
				'label' => esc_html__('Slider Controls', 'photomentor'),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'label_off' => esc_html__('No', 'photomentor'),
				'label_on' => esc_html__('Yes', 'photomentor'),
                'prefix_class' => 'photomentor_slider_controls_',
			]
		);
		
		$this->add_control(
			'controls_style_divider',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'controls_state' => 'yes'
				]
			]
		);

		$this->add_responsive_control(
			'controls_size',
			[
				'label' => esc_html__('Size', 'photomentor'),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 20,
					'unit' => 'px'
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100
					]
				],
				'condition' => [
					'controls_state' => 'yes'
				],
				'selectors' => [
					'{{WRAPPER}} a.photomentor_slider_control i' => 'font-size: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}}; width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};'
				]
			]
		);

		$this->add_control(
			'controls_padding',
			[
				'label' => esc_html__('Padding', 'photomentor'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px'],
				'selectors' => [
					'{{WRAPPER}} a.photomentor_slider_control' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				],
				'condition' => [
					'controls_state' => 'yes'
				],
				'separator' => 'before'
			]
		);
		
		$this->add_responsive_control(
			'controls_margin',
			[
				'label' => esc_html__('Spacing', 'photomentor'),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 20,
					'unit' => 'px'
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100
					]
				],
				'condition' => [
					'controls_state' => 'yes'
				],
                'separator' => 'before',
				'selectors' => [
					'{{WRAPPER}} a.photomentor_slider_control.photomentor_slider_btn_prev' => 'left: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} a.photomentor_slider_control.photomentor_slider_btn_next' => 'right: {{SIZE}}{{UNIT}};'
				]
			]
		);

		$this->start_controls_tabs('more_button_settings_tabs');
	
            // ------ Tab Normal ------ //
            $this->start_controls_tab(
                'tab_control_normal',
                [
                    'label' => esc_html__('Normal', 'photomentor'),
                    'condition' => [
                        'controls_state' => 'yes'
                    ]
                ]
            );

                $this->add_control(
                    'controls_color',
                    [
                        'label' => esc_html__('Color', 'photomentor'),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} a.photomentor_slider_control' => 'color: {{VALUE}};'
                        ],
                        'separator' => 'before',
                        'condition' => [
                            'controls_state' => 'yes'
                        ]
                    ]
                );

                $this->add_control(
                    'controls_bg',
                    [
                        'label' => esc_html__('Background', 'photomentor'),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} a.photomentor_slider_control' => 'background-color: {{VALUE}};'
                        ],
                        'separator' => 'before',
                        'condition' => [
                            'controls_state' => 'yes'
                        ]
                    ]
                );

            $this->end_controls_tab();

            // ------ Tab Hover ------ //
            $this->start_controls_tab(
                'tab_controls_hover',
                [
                    'label' => esc_html__('Hover', 'photomentor'),
                    'condition' => [
                        'controls_state' => 'yes'
                    ]
                ]
            );

                $this->add_control(
                    'controls_color_hover',
                    [
                        'label' => esc_html__('Color', 'photomentor'),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} a.photomentor_slider_control:hover' => 'color: {{VALUE}};'
                        ],
                        'separator' => 'before',
                        'condition' => [
                            'controls_state' => 'yes'
                        ]
                    ]
                );
        
                $this->add_control(
                    'controls_bg_hover',
                    [
                        'label' => esc_html__('Background', 'photomentor'),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} a.photomentor_slider_control:hover' => 'background-color: {{VALUE}};'
                        ],
                        'separator' => 'before',
                        'condition' => [
                            'controls_state' => 'yes'
                        ]
                    ]
                );

            $this->end_controls_tab();
		
		$this->end_controls_tabs();

		$this->add_control(
			'controls_border_radius',
			[
				'label' => esc_html__('Border Radius', 'photomentor'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px','%'],
				'selectors' => [
					'{{WRAPPER}} a.photomentor_slider_control' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				],
				'condition' => [
					'controls_state' => 'yes'
				],
				'separator' => 'before'
			]
		);

		$this->end_controls_section();

	}
	
	protected function render() {
		$settings = $this->get_settings();
		
		$slider_item = $settings['slider_item'];
		$fit_style = $settings['fit_style'];
		$fx_type = $settings['fx_type'];
		$module_height_state = $settings['module_height_state'];
		$module_height = $settings['module_height'];
		$autoplay_state = $settings['autoplay'];
		$autoplay_speed = $settings['autoplay_speed'];
		$overlay = $settings['overlay'];
		
		$autoplay = 'off';
		
		if ($autoplay_state == 'yes') {
			$autoplay = 'on';
		}
		
		$poh_class = '';
		
		if ($settings['pause_on_hover'] == 'yes') {
			$poh_class = 'pause_on_hover';
		}
		
		$uniqid = $this->get_id();
		
		$additional_class = '';
		
		$exclude_class = $settings['exclude_class'];
		$reduce_classes = $settings['reduce_classes'];
		$exclude_height = $settings['exclude_height'];
		$reduce_height = $settings['reduce_height'];
		
		if ($exclude_class == 'yes') {
			$additional_class = $additional_class . ' exclude_class';
		}
		if ($exclude_height == 'yes') {
			$additional_class = $additional_class . ' exclude_height';
		}

		// ------------------------------------ //
		// ---------- Widget Content ---------- //
		// ------------------------------------ //
		if (empty($slider_item)) {
			return;
		}
		?>
		
		<div class="photomentor_gallery_content_container">
				<?php
				if ($module_height_state == 'auto') {
				?>
			<div class="photomentor_slider_wrapper photomentor_no_select photomentor_module_loading auto_height <?php echo esc_attr($poh_class); ?>" data-autoplay = "<?php echo esc_attr($autoplay); ?>" data-interval = "<?php echo esc_attr($autoplay_speed); ?>" data-id="<?php echo esc_attr($uniqid); ?>">
				<?php
				}
				
				else if ($module_height_state == 'screen_height') {
				?>
			<div class="photomentor_slider_wrapper photomentor_no_select photomentor_module_loading screen_height <?php echo esc_attr($poh_class); ?> <?php echo esc_attr($additional_class); ?>" data-autoplay = "<?php echo esc_attr($autoplay); ?>" data-interval = "<?php echo esc_attr($autoplay_speed); ?>" data-id="<?php echo esc_attr($uniqid); ?>" data-classes = "<?php echo esc_attr($reduce_classes); ?>" data-rheight = "<?php echo esc_attr($reduce_height); ?>">
				<?php
				}
				
				else {
				?>
			<div class="photomentor_slider_wrapper photomentor_slider_wrapper_custom_height photomentor_no_select photomentor_module_loading <?php echo esc_attr($poh_class); ?>" data-autoplay = "<?php echo esc_attr($autoplay); ?>" data-interval = "<?php echo esc_attr($autoplay_speed); ?>" data-id="<?php echo esc_attr($uniqid); ?>">
				<?php
				}
				?>
		
				<div class="photomentor_slider_with_content photomentor_slider <?php echo esc_attr($fit_style); ?> photomentor_slider_<?php echo esc_attr($fx_type); ?>" data-autoplay = "<?php echo esc_attr($autoplay); ?>" data-interval = "<?php echo esc_attr($autoplay_speed); ?>">
					<?php
					$count = 0;
					
					foreach ($slider_item as $item) {
						$count++;
						
						$slide_color = $item['slide_color'];
						$slide_image = $item['slide_image'];
						$slide_image = wp_get_attachment_image_src($slide_image['id'], 'original');
						$custom_slide_bg = $item['custom_slide_bg'];
						
						$custom_fit_class= '';
						if ($custom_slide_bg == 'yes') {
							$fit_style_slide = $item['fit_style_slide'];
							$custom_fit_class = $item['fit_style_slide'];
							$overlay_slide = $item['overlay_slide'];
						}
						$slide_title = $item['slide_title'];
						$slide_description = $item['slide_description'];
						$slide_button_text = $item['slide_button_text'];
						$slide_link_url = $item['slide_link_url'];
						
						$target = '_self';
						$nofollow = '';
						
						if ($slide_link_url['is_external'] == 'true' || $slide_link_url['is_external'] == 'on') {
							$target = '_blank';
						}
						if ($slide_link_url['nofollow'] == 'true' || $slide_link_url['nofollow'] == 'on') {
							$nofollow = 'nofollow';
						}
						
						?>
						<div class="photomentor_slider_slide photomentor_slide2preload <?php echo esc_attr($custom_fit_class); ?> photomentor_slider_slide<?php echo esc_attr($count); ?>" data-count="<?php echo esc_attr($count); ?>">
							<div class="photomentor_slider_slide_inner" style="background: url('<?php echo esc_url($slide_image[0]); ?>')">
								<?php
								if ($slide_title !== '' || $slide_description !== '' || $slide_button_text !== '') {
									?>
	                                <div class="photomentor_slider_content_box">
	                                    <div class="photomentor_slider_content">
	                                    <?php
										if ($slide_title !== '') {
											?>
											<h2 class="photomentor_slider_title"><?php echo esc_html($slide_title); ?></h2>
											<?php
										}
										if ($slide_description !== '') {
											?>
											<p class="photomentor_slider_description"><?php echo esc_html($slide_description); ?></p>
											<?php
										}
										if ($slide_button_text !== '') {
											?>
											<a href="<?php echo esc_url($slide_link_url['url']); ?>" target="<?php echo esc_attr($target); ?>" <?php echo !empty($nofollow) ? 'rel="'. esc_attr($nofollow) . '"' : ''; ?> class="photomentor_slider_button"><?php echo esc_html($slide_button_text); ?></a>
											<?php
										}
										?>
										</div><!-- photomentor_slider_content -->
	                                </div><!-- photomentor_slider_content_box -->
	                                <?php
								}
								
								if ($custom_slide_bg == 'yes' && $overlay_slide == 'yes') {
									if ($item['overlay_color_slide_background'] == 'gradient') {
										$color01 = $item['overlay_color_slide_color'];
										$color01_pos = $item['overlay_color_slide_color_stop'];
										$color01_pos_string = $color01_pos['size'].$color01_pos['unit'];
										$color02 = $item['overlay_color_slide_color_b'];
										$color02_pos = $item['overlay_color_slide_color_b_stop'];
										$color02_pos_string = $color02_pos['size'].$color02_pos['unit'];
										$grad_type = $item['overlay_color_slide_gradient_type'];
										if ($grad_type == 'linear') {

											$grad_angle = $item['overlay_color_slide_gradient_angle'];
											$grad_angle_string = $grad_angle['size'].$grad_angle['unit'];
											$bg_gradient_string = $grad_type .'-gradient('. $grad_angle_string.', '. $color01 .' '. $color01_pos_string .', ' . $color02 .' ' . $color02_pos_string .')';
										} else {
											$bg_gradient_string = $grad_type .'-gradient('. $color01 .' '. $color01_pos_string .', ' . $color02 .' ' . $color02_pos_string .')';
										}
										?>
										<span class="photomentor_slider_overlay_custom photomentor_js_bg_gradient" data-bggrad="<?php echo $bg_gradient_string; ?>"></span>
										<?php
									} else {
										?>
										<span class="photomentor_slider_overlay_custom photomentor_js_bg_color" data-bgcolor="<?php echo $item['overlay_color_slide_color']; ?>"></span>
										<?php
									}
								} else {
									if ($overlay == 'yes') {
										?>
										<span class="photomentor_slider_overlay"></span>
										<?php
									}
								}
								?>
							</div><!-- photomentor_slider_slide_inner -->
						</div><!-- photomentor_slider_slide -->
						<?php
					}
					?>
				</div>
		
                <a href="<?php echo esc_js("javascript:void(0)"); ?>" class="photomentor_slider_btn_prev photomentor_slider_control"><i class="pm-icon-angle-left"></i></a>
                <a href="<?php echo esc_js("javascript:void(0)"); ?>" class="photomentor_slider_btn_next photomentor_slider_control"><i class="pm-icon-angle-right"></i></a>
			</div>
		</div>
		<?php
	}
	
	protected function content_template() {}
	
	public function render_plain_content() {}
}
