<?php
/*
 * Created by Pixel-Mafia
 * www.pixel-mafia.com
*/

namespace Photomentor\Core\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Photomentor_Gallery_Ribbon_Custom_Widget extends Widget_Base {
	
	public function get_name() {
		return 'photomentor-gallery-ribbon-custom';
	}
	
	public function get_title() {
		return esc_html__('Custom Ribbon', 'photomentor');
	}
	
	public function get_icon() {
		return 'eicon-slider-album';
	}
	
	public function get_categories() {
		return ['photomentor_gallery_widgets'];
	}
	
	public function get_script_depends() {
		return ['gallery_ribbon'];
	}
	
	protected function _register_controls() {
		// ----------------------------- //
		// ---------- Content ---------- //
		// ----------------------------- //
		$this->start_controls_section(
			'section_gallery',
			[
				'label' => esc_html__('Gallery', 'photomentor')
			]
		);
		
		$this->add_control(
			'ribbon_items',
			[
				'label' => esc_html__('Add Items', 'photomentor'),
				'type' => Controls_Manager::REPEATER,
				'fields' => [
					[
						'name' => 'slide_image',
						'label' => esc_html__('Select Image', 'photomentor'),
						'type' => Controls_Manager::MEDIA,
						'default' => [
							'url' => Utils::get_placeholder_image_src(),
						]
					],
					[
						'name' => 'slide_caption_type',
						'label' => esc_html__( 'Caption Type', 'photomentor' ),
						'type' => Controls_Manager::SELECT,
						'default' => 'default',
						'options' => [
							'default' => esc_html__( 'Default', 'photomentor' ),
							'custom' => esc_html__( 'Custom', 'photomentor' ),
						]
					],
					[
						'name' => 'slide_caption',
						'label' => esc_html__('Slide Caption', 'photomentor'),
						'type' => Controls_Manager::TEXT,
						'default' => '',
						'condition' => [
							'slide_caption_type' => 'custom'
						]
					],
					[
						'name' => 'slide_url',
						'label' => esc_html__('Link URL', 'photomentor'),
						'type' => Controls_Manager::URL,
						'default' => [
							'url' => '',
							'is_external' => 'true',
						],
						'placeholder' => esc_html__( 'http://your-link.com', 'photomentor' ),
					]
				]
			]
		);
		
		$this->add_control(
			'control_divider_0',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);
		
		$this->add_control(
			'module_height_state',
			[
				'label' => esc_html__('Module Height Type', 'photomentor'),
				'type' => Controls_Manager::SELECT,
				'default' => 'screen_height',
				'options' => [
					'auto' => esc_html__('Auto', 'photomentor'),
					'screen_height' => esc_html__('Screen Height', 'photomentor'),
					'custom' => esc_html__('Custom', 'photomentor')
				]
			]
		);
		
		$this->add_control(
			'control_divider_1x',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'module_height_state' => 'screen_height'
				]
			]
		);

		$this->add_control(
			'exclude_class',
			[
				'label' => esc_html__('Reduce Height By Classes', 'photomentor'),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'no',
				'label_off' => esc_html__('No', 'photomentor'),
				'label_on' => esc_html__('Yes', 'photomentor'),
				'condition' => [
					'module_height_state' => 'screen_height'
				]
			]
		);

		$this->add_control(
			'control_divider_1ec',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'module_height_state' => 'screen_height',
					'exclude_class' => 'yes'
				]
			]
		);

		$this->add_control(
			'reduce_classes',
			[
				'label' => esc_html__('Classes to Exclude (separate by commas)', 'photomentor'),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => '',
				'condition' => [
					'module_height_state' => 'screen_height',
					'exclude_class' => 'yes'
				]
			]
		);

		$this->add_control(
			'control_divider_1ecx',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'module_height_state' => 'screen_height',
				]
			]
		);

		$this->add_control(
			'exclude_height',
			[
				'label' => esc_html__('Reduce Height in PX', 'photomentor'),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'no',
				'label_off' => esc_html__('No', 'photomentor'),
				'label_on' => esc_html__('Yes', 'photomentor'),
				'condition' => [
					'module_height_state' => 'screen_height'
				]
			]
		);

		$this->add_control(
			'control_divider_1eh',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'module_height_state' => 'screen_height',
					'exclude_height' => 'yes'
				]
			]
		);

		$this->add_control(
			'reduce_height',
			[
				'label' => esc_html__('Height to Reduce, PX', 'photomentor'),
				'type' => Controls_Manager::NUMBER,
				'default' => 0,
				'min' => 0,
				'step' => 1,
				'condition' => [
					'module_height_state' => 'screen_height',
					'exclude_height' => 'yes'
				]
			]
		);

		$this->add_control(
			'control_divider_1',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'module_height_state' => 'custom'
				]
			]
		);
		
		$this->add_control(
			'module_height',
			[
				'label' => esc_html__('Module Height', 'photomentor'),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 750,
					'unit' => 'px'
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 2000
					]
				],
				'condition' => [
					'module_height_state' => 'custom'
				],
				'selectors' => [
					'{{WRAPPER}} .photomentor_slider_wrapper_custom_height' => 'height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .photomentor_slider_wrapper_custom_height img' => 'height: {{SIZE}}{{UNIT}}; width: auto;'
				]
			]
		);
		
		$this->add_control(
			'control_divider_4',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);
		
		$this->add_control(
			'autoplay_state',
			[
				'label' => esc_html__('Autoplay', 'photomentor'),
				'type' => Controls_Manager::SELECT,
				'default' => 'yes',
				'options' => [
					'yes' => esc_html__('Yes', 'photomentor'),
					'no' => esc_html__('No', 'photomentor')
				]
			]
		);
		
		$this->add_control(
			'control_divider_5',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'display_time',
			[
				'label' => esc_html__('Autoplay Speed', 'photomentor'),
				'type' => Controls_Manager::NUMBER,
				'default' => 4000,
				'min' => 0,
				'step' => 100,
				'condition' => [
					'autoplay_state' => 'yes'
				]
			]
		);
		
		$this->add_control(
			'control_divider_6',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'pause_on_hover',
			[
				'label' => esc_html__('Pause on Hover', 'photomentor'),
				'type' => Controls_Manager::SELECT,
				'default' => 'yes',
				'options' => [
					'yes' => esc_html__('Yes', 'photomentor'),
					'no' => esc_html__('No', 'photomentor')
				],
				'condition' => [
					'autoplay_state' => 'yes'
				]
			]
		);
		
		$this->end_controls_section();
		
		// -------------------------------------- //
		// ---------- Gallery Settings ---------- //
		// -------------------------------------- //
		$this->start_controls_section(
			'section_gallery_settings',
			[
				'label' => esc_html__('Gallery Settings', 'photomentor'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_control(
			'overlay_state',
			[
				'label' => esc_html__('Side Overlays', 'photomentor'),
				'type' => Controls_Manager::SELECT,
				'default' => 'off',
				'options' => [
					'on' => esc_html__('On', 'photomentor'),
					'off' => esc_html__('Off', 'photomentor')
				]
			]
		);
		
		$this->add_control(
			'control_divider_7',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);
		
		$this->add_control(
			'title_state',
			[
				'label' => esc_html__('Title State', 'photomentor'),
				'type' => Controls_Manager::SELECT,
				'default' => 'hover',
				'options' => [
					'hover' => esc_html__('Show on Hover', 'photomentor'),
					'active' => esc_html__('Show on Active', 'photomentor'),
					'show' => esc_html__('Always Show', 'photomentor'),
					'hide' => esc_html__('Hide', 'photomentor')
				]
			]
		);
		
		$this->add_control(
			'control_divider_8',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => esc_html__('Title Typography', 'photomentor'),
				'selector' => '{{WRAPPER}} .photomentor_ribbon_content h2',
				'condition' => [
					'title_state!' => 'hide'
				]
			]
		);
		
		$this->add_control(
			'control_divider_9',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'title_color',
			[
				'label' => esc_html__('Title Color', 'photomentor'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .photomentor_ribbon_content h2' => 'color: {{VALUE}};'
				],
				'condition' => [
					'title_state!' => 'hide'
				]
			]
		);
		
		$this->add_control(
			'control_divider_10',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'title_align',
			[
				'label' => esc_html__('Title Alignment', 'photomentor'),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'photomentor' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'photomentor' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'photomentor' ),
						'icon' => 'eicon-text-align-right',
					]
				],
				'default' => 'center',
				'selectors' => [
					'{{WRAPPER}} .photomentor_ribbon_content' => 'text-align: {{VALUE}};'
				],
				'condition' => [
					'title_state!' => 'hide'
				]
			]
		);
		
		$this->add_control(
			'control_divider_11',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);
		
		$this->add_control(
			'set_pad',
			[
				'label' => esc_html__('Spaces Between Items', ''),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 30,
					'unit' => 'px'
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200
					]
				]
			]
		);
		
		$this->end_controls_section();
        
		// -------------------------------------- //
		// ---------- Controls Settings ---------- //
		// -------------------------------------- //
		$this->start_controls_section(
			'section_controls_settings',
			[
				'label' => esc_html__('Controls Settings', 'photomentor'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'controls_state',
			[
				'label' => esc_html__('Slider Controls', 'photomentor'),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'label_off' => esc_html__('No', 'photomentor'),
				'label_on' => esc_html__('Yes', 'photomentor'),
                'prefix_class' => 'photomentor_slider_controls_',
			]
		);
		
		$this->add_control(
			'controls_style_divider',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'controls_state' => 'yes'
				]
			]
		);

		$this->add_responsive_control(
			'controls_size',
			[
				'label' => esc_html__('Size', 'photomentor'),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 20,
					'unit' => 'px'
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100
					]
				],
				'condition' => [
					'controls_state' => 'yes'
				],
				'selectors' => [
					'{{WRAPPER}} .photomentor_ribbon_slider_wrapper.owl-theme .owl-nav [class*="owl-"]:before' => 'font-size: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}}; width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};'
				]
			]
		);

		$this->add_control(
			'controls_padding',
			[
				'label' => esc_html__('Padding', 'photomentor'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px'],
				'selectors' => [
					'{{WRAPPER}} .photomentor_ribbon_slider_wrapper.owl-theme .owl-nav [class*="owl-"]' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				],
				'condition' => [
					'controls_state' => 'yes'
				],
				'separator' => 'before'
			]
		);
		
		$this->add_responsive_control(
			'controls_margin',
			[
				'label' => esc_html__('Spacing', 'photomentor'),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 20,
					'unit' => 'px'
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100
					]
				],
				'condition' => [
					'controls_state' => 'yes'
				],
                'separator' => 'before',
				'selectors' => [
					'{{WRAPPER}} .photomentor_ribbon_slider_wrapper .owl-nav > div.owl-prev' => 'left: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .photomentor_ribbon_slider_wrapper .owl-nav > div.owl-next' => 'right: {{SIZE}}{{UNIT}};'
				]
			]
		);

		$this->start_controls_tabs('more_button_settings_tabs');
	
            // ------ Tab Normal ------ //
            $this->start_controls_tab(
                'tab_control_normal',
                [
                    'label' => esc_html__('Normal', 'photomentor'),
                    'condition' => [
                        'controls_state' => 'yes'
                    ]
                ]
            );

                $this->add_control(
                    'controls_color',
                    [
                        'label' => esc_html__('Color', 'photomentor'),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .photomentor_ribbon_slider_wrapper.owl-theme .owl-nav [class*="owl-"]:before' => 'color: {{VALUE}};'
                        ],
                        'separator' => 'before',
                        'condition' => [
                            'controls_state' => 'yes'
                        ]
                    ]
                );

                $this->add_control(
                    'controls_bg',
                    [
                        'label' => esc_html__('Background', 'photomentor'),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .photomentor_ribbon_slider_wrapper.owl-theme .owl-nav [class*="owl-"]' => 'background-color: {{VALUE}};'
                        ],
                        'separator' => 'before',
                        'condition' => [
                            'controls_state' => 'yes'
                        ]
                    ]
                );

            $this->end_controls_tab();

            // ------ Tab Hover ------ //
            $this->start_controls_tab(
                'tab_controls_hover',
                [
                    'label' => esc_html__('Hover', 'photomentor'),
                    'condition' => [
                        'controls_state' => 'yes'
                    ]
                ]
            );

                $this->add_control(
                    'controls_color_hover',
                    [
                        'label' => esc_html__('Color', 'photomentor'),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .photomentor_ribbon_slider_wrapper.owl-theme .owl-nav [class*="owl-"]:hover:before' => 'color: {{VALUE}};'
                        ],
                        'separator' => 'before',
                        'condition' => [
                            'controls_state' => 'yes'
                        ]
                    ]
                );
        
                $this->add_control(
                    'controls_bg_hover',
                    [
                        'label' => esc_html__('Background', 'photomentor'),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .photomentor_ribbon_slider_wrapper.owl-theme .owl-nav [class*="owl-"]:hover' => 'background-color: {{VALUE}};'
                        ],
                        'separator' => 'before',
                        'condition' => [
                            'controls_state' => 'yes'
                        ]
                    ]
                );

            $this->end_controls_tab();
		
		$this->end_controls_tabs();

		$this->add_control(
			'controls_border_radius',
			[
				'label' => esc_html__('Border Radius', 'photomentor'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px','%'],
				'selectors' => [
					'{{WRAPPER}} .photomentor_ribbon_slider_wrapper.owl-theme .owl-nav [class*="owl-"]' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				],
				'condition' => [
					'controls_state' => 'yes'
				],
				'separator' => 'before'
			]
		);

		$this->end_controls_section();

	}
	
	protected function render() {
		$settings = $this->get_settings();
		
		$ribbon_items = $settings['ribbon_items'];
		$module_height_state = $settings['module_height_state'];
		$overlay_state = $settings['overlay_state'];
		$title_state = $settings['title_state'];
		$set_pad = $settings['set_pad']['size'];
		$autoplay_state = $settings['autoplay_state'];
		$display_time = $settings['display_time'];
		$pause_on_hover = $settings['pause_on_hover'];
		
		$additional_class = '';
		
		$exclude_class = $settings['exclude_class'];
		$reduce_classes = $settings['reduce_classes'];
		$exclude_height = $settings['exclude_height'];
		$reduce_height = $settings['reduce_height'];
		
		if ($exclude_class == 'yes') {
			$additional_class = $additional_class . ' exclude_class';
		}
		if ($exclude_height == 'yes') {
			$additional_class = $additional_class . ' exclude_height';
		}
		
		if ($autoplay_state == 'yes') {
			$autoplay_class = 'autoplay';
		} else {
			$autoplay_class = 'no_autoplay';
		}
		
		$uniqid = mt_rand(0, 9999);
		
		// ------------------------------------ //
		// ---------- Widget Content ---------- //
		// ------------------------------------ //
		if (empty($ribbon_items)) {
			return;
		}
		?>
		
		<div class="photomentor_gallery_ribbon_container">
				<?php
				if ($module_height_state == 'auto') {
				?>
			<div class="photomentor_ribbon_slider_wrapper photomentor_no_select owl-carousel owl-theme auto_height photomentor_ribbon_gal_<?php echo esc_attr($uniqid); ?> photomentor_ribbon_overlay_<?php echo esc_attr($overlay_state); ?> photomentor_ribbon_title_<?php echo esc_attr($title_state); ?>" data-uniqid="<?php echo esc_attr($uniqid); ?>" data-pad="<?php echo esc_attr($set_pad); ?>" data-pause = "<?php echo esc_attr($pause_on_hover); ?>" data-autoplay = "<?php echo esc_attr($autoplay_state); ?>" data-speed = "<?php echo esc_attr($display_time); ?>">
				<?php
				}
				else if ($module_height_state == 'screen_height') {
				?>
			<div class="photomentor_ribbon_slider_wrapper photomentor_no_select owl-carousel owl-theme screen_height photomentor_ribbon_gal_<?php echo esc_attr($uniqid); ?> photomentor_ribbon_overlay_<?php echo esc_attr($overlay_state); ?> photomentor_ribbon_title_<?php echo esc_attr($title_state); ?> <?php echo esc_attr($additional_class); ?>" data-uniqid="<?php echo esc_attr($uniqid); ?>" data-pad="<?php echo esc_attr($set_pad); ?>" data-pause = "<?php echo esc_attr($pause_on_hover); ?>" data-autoplay = "<?php echo esc_attr($autoplay_state); ?>" data-speed = "<?php echo esc_attr($display_time); ?>" data-classes = "<?php echo esc_attr($reduce_classes); ?>" data-rheight = "<?php echo esc_attr($reduce_height); ?>">
				<?php
				}
				else {
				?>
			<div class="photomentor_ribbon_slider_wrapper photomentor_slider_wrapper_custom_height photomentor_no_select owl-carousel owl-theme photomentor_ribbon_gal_<?php echo esc_attr($uniqid); ?> photomentor_ribbon_overlay_<?php echo esc_attr($overlay_state); ?> photomentor_ribbon_title_<?php echo esc_attr($title_state); ?>" data-uniqid="<?php echo esc_attr($uniqid); ?>" data-pad="<?php echo esc_attr($set_pad); ?>" data-pause = "<?php echo esc_attr($pause_on_hover); ?>" data-autoplay = "<?php echo esc_attr($autoplay_state); ?>" data-speed = "<?php echo esc_attr($display_time); ?>">
				<?php
				}
		
				$count = 0;
				foreach ( $ribbon_items as $item ) {
					$count++;
					
					$slide_image = $item['slide_image'];
					$slide_caption_type = $item['slide_caption_type'];
					$slide_caption = $item['slide_caption'];
					$slide_url = $item['slide_url'];

					$photoTitle = '';
					$attach_meta = photomentor_get_attachment($slide_image['id']);
					if ($slide_caption_type == 'default') {
						$photoTitle = $attach_meta['caption'];
					} else {
						$photoTitle = $item['slide_caption'];
					}
					$photoAlt = $attach_meta['alt'];
					$PCREpattern = '/\r\n|\r|\n/u';

					$target = 'target="_self"';
					$nofollow = '';
					if ($slide_url['is_external'] == 'true' || $slide_url['is_external'] == 'on') {
						$target = 'target="_blank"';
					}
					if ($slide_url['nofollow'] == 'true' || $slide_url['nofollow'] == 'on') {
						$nofollow = 'rel="nofollow"';
					}
					
					$photoTitle = preg_replace($PCREpattern, '', nl2br($photoTitle));
					
					$slide_meta = wp_get_attachment_metadata($slide_image['id']);
					
					$slide_ratio = $slide_meta['width']/$slide_meta['height'];
					$slide_width = round($slide_meta['width']/10);
					$slide_height = round($slide_width/$slide_ratio);
					
					$featured_image = wp_get_attachment_url($slide_image['id']);
					
					?>
					<div class="photomentor_ribbon_slide photomentor_js_transition" data-ratio="<?php echo esc_attr($slide_ratio); ?>">
						<img alt="<?php echo esc_attr($photoTitle); ?>" src="<?php echo esc_url($featured_image); ?>"/>
						
						<?php 
						if ($photoTitle !== '' && $title_state !== 'hide') { 
							?>
							<div class="photomentor_ribbon_content">
								<h2><?php echo esc_attr($photoTitle); ?></h2>
							</div>
							<?php 
						}
						if (!empty($slide_url['url'])) {
							echo '<a href="'. esc_url($slide_url['url']) .'" '. $target .' '. $nofollow .'></a>';
						}
						?>
					</div>
					<?php
				}
				?>
			</div>
		</div>
		<?php
	}
	
	protected function content_template() {}
	
	public function render_plain_content() {}
}

