<?php
/*
 * Created by Pixel-Mafia
 * www.pixel-mafia.com
*/

namespace Photomentor\Core\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\REPEATER;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Photomentor_Gallery_Media_Proofing_Masonry_Widget extends Widget_Base {
	
	public function get_name() {
		return 'photomentor-gallery-media-proofing-masonry';
	}
	
	public function get_title() {
		return esc_html__('Gallery Media Proofing Masonry', 'photomentor');
	}
	
	public function get_icon() {
		return 'eicon-gallery-masonry picon-proofing';
	}
	
	public function get_categories() {
		return ['photomentor_gallery_widgets'];
	}
	
	public function get_script_depends() {
		return ['gallery_grid'];
	}

	protected function _register_controls() {
		
		// ----------------------------- //
		// ---------- Content ---------- //
		// ----------------------------- //
		$this->start_controls_section(
			'section_gallery',
			[
				'label' => esc_html__('Gallery', 'photomentor')
			]
		);
		
		$this->add_control(
			'media_grid_items',
			[
				'label' => esc_html__('Media Items', 'photomentor'),
				'type' => Controls_Manager::REPEATER,
				'fields' => [
					[
						'name' => 'slide_type',
						'label' => esc_html__( 'Item Type', 'photomentor' ),
						'type' => Controls_Manager::SELECT,
						'default' => 'image',
						'options' => [
							'image' => esc_html__( 'Image', 'photomentor' ),
							'video' => esc_html__( 'Video', 'photomentor' ),
						]
					],
					
					[
						'name' => 'video_url',
						'label' => esc_html__('Video URL', 'photomentor'),
						'type' => Controls_Manager::TEXT,
						'default' => '',
						'condition' => [
							'slide_type' => 'video'
						]
					],
					
					[
						'name' => 'slide_image',
						'label' => esc_html__('Select Image', 'photomentor'),
						'type' => Controls_Manager::MEDIA,
						'default' => [
							'url' => Utils::get_placeholder_image_src(),
						],
						'condition' => [
							'slide_type' => 'image'
						]
					],
					
					[
						'name' => 'slide_thmb',
						'label' => esc_html__('Select Image', 'photomentor'),
						'type' => Controls_Manager::MEDIA,
						'default' => [
							'url' => Utils::get_placeholder_image_src(),
						],
						'condition' => [
							'slide_type' => 'video'
						]
					],
					
					[
						'name' => 'slide_caption_type',
						'label' => esc_html__( 'Caption Type', 'photomentor' ),
						'type' => Controls_Manager::SELECT,
						'default' => 'default',
						'options' => [
							'default' => esc_html__( 'Default', 'photomentor' ),
							'custom' => esc_html__( 'Custom', 'photomentor' ),
						]
					],
					
					[
						'name' => 'slide_caption',
						'label' => esc_html__('Slide Caption', 'photomentor'),
						'type' => Controls_Manager::TEXT,
						'default' => '',
						'condition' => [
							'slide_caption_type' => 'custom'
						]
					]
				]
			]
		);
		
		$this->end_controls_section();
		
		// -------------------------------------- //
		// ---------- Gallery Settings ---------- //
		// -------------------------------------- //
		$this->start_controls_section(
			'section_gallery_settings',
			[
				'label' => esc_html__('General Settings', 'photomentor'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_control(
			'columns',
			[
				'label' => esc_html__('Columns', 'photomentor'),
				'type' => Controls_Manager::SELECT,
				'default' => 3,
				'options' => [
					2 => esc_html__('Two Columns', 'photomentor'),
					3 => esc_html__('Three Columns', 'photomentor'),
					4 => esc_html__('Four Columns', 'photomentor'),
				]
			]
		);
		
		$this->add_control(
			'control_divider_0',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);
		
		$this->add_control(
			'filter_status',
			[
				'label' => esc_html__('Filter', 'photomentor'),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'label_off' => esc_html__('Hide', 'photomentor'),
				'label_on' => esc_html__('Show', 'photomentor')
			]
		);
		
		$this->add_control(
			'control_divider_1',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'title_status',
			[
				'label' => esc_html__('Image Title', 'photomentor'),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'label_off' => esc_html__('Hide', 'photomentor'),
				'label_on' => esc_html__('Show', 'photomentor')
			]
		);
		
		$this->add_control(
			'control_divider_2',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'overlay_status',
			[
				'label' => esc_html__('Image Overlay', 'photomentor'),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'label_off' => esc_html__('Hide', 'photomentor'),
				'label_on' => esc_html__('Show', 'photomentor')
			]
		);
		
		$this->add_control(
			'control_divider_3',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'download_button_status',
			[
				'label' => esc_html__('Download Button', 'photomentor'),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'label_off' => esc_html__('Hide', 'photomentor'),
				'label_on' => esc_html__('Show', 'photomentor')
			]
		);
		
		$this->add_control(
			'control_divider_4',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'notify_status',
			[
				'label' => esc_html__('Notify by Email?', 'photomentor'),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'no',
				'label_off' => esc_html__('Yes', 'photomentor'),
				'label_on' => esc_html__('No', 'photomentor')
			]
		);
		
		$this->add_control(
			'control_divider_5',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'notify_status' => 'yes'
				]
			]
		);
		
		$this->add_control(
			'notify_email',
			[
				'label' => esc_html__('Email Address', 'photomentor'),
				'type' => Controls_Manager::TEXT,
				'default' => get_option('admin_email'),
				'condition' => [
					'notify_status' => 'yes'
				]
			]
		);
		
		$this->end_controls_section();
		
		// ------------------------------------ //
		// ---------- Style Settings ---------- //
		// ------------------------------------ //
		$this->start_controls_section(
			'section_style_settings',
			[
				'label' => esc_html__('Gallery Style Settings', 'photomentor'),
				'tab' => Controls_Manager::TAB_STYLE
			]
		);
		
		$this->add_control(
			'image_size_status',
			[
				'label' => esc_html__('Image Custom Size', 'photomentor'),
				'type' => Controls_Manager::POPOVER_TOGGLE,
				'return_value' => 'yes'
			]
		);
		
		$this->start_popover();
		
		$this->add_control(
			'image_width',
			[
				'label' => esc_html__('Image Width', 'photomentor'),
				'type' => Controls_Manager::NUMBER,
				'default' => 960,
				'min' => 1,
				'condition' => [
					'image_size_status' => 'yes'
				]
			]
		);
		
		$this->end_popover();
		
		$this->add_control(
			'control_divider_8x',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);
		
		$this->add_control(
			'item_border_radius',
			[
				'label' => esc_html__('Border Radius', 'photomentor'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .photomentor_proofing_grid_item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->add_control(
			'control_divider_6',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);
		
		$this->add_control(
			'items_padding',
			[
				'label' => esc_html__('Spaces Between Items', 'photomentor'),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200
					]
				],
				'selectors' => [
					'{{WRAPPER}} .grid-item-inner' => 'padding-left: {{SIZE}}{{UNIT}}; padding-bottom: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .photomentor_grid_inner' => 'margin-left: -{{SIZE}}{{UNIT}};'
				]
			]
		);
		
		$this->add_control(
			'control_divider_7',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'filter_typography',
				'label' => esc_html__('Filter Typography', 'photomentor'),
				'selector' => '{{WRAPPER}} .photomentor_grid_filter li',
				'condition' => [
					'filter_status' => 'yes'
				]
			]
		);
		
		$this->add_control(
			'control_divider_8',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'filter_color',
			[
				'label' => esc_html__('Filter Color', 'photomentor'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .photomentor_grid_filter li a' => 'color: {{VALUE}};'
				],
				'condition' => [
					'filter_status' => 'yes'
				]
			]
		);
		
		$this->add_control(
			'control_divider_9',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'filter_hover',
			[
				'label' => esc_html__('Filter Hover Color', 'photomentor'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .photomentor_grid_filter li a:hover, {{WRAPPER}} .photomentor_grid_filter li.is-checked a' => 'color: {{VALUE}};'
				],
				'condition' => [
					'filter_status' => 'yes'
				]
			]
		);
		
		$this->add_control(
			'control_divider_10',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => esc_html__('Image Title Typography', 'photomentor'),
				'selector' => '{{WRAPPER}} .grid-item-content h4',
				'condition' => [
					'title_status' => 'yes'
				]
			]
		);
		
		$this->add_control(
			'control_divider_11',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'title_color',
			[
				'label' => esc_html__('Image Title Color', 'photomentor'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .grid-item-content h4' => 'color: {{VALUE}};'
				],
				'condition' => [
					'title_status' => 'yes'
				]
			]
		);
		
		$this->add_control(
			'control_divider_12',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);
		
		$this->add_control(
			'overlay_color',
			[
				'label' => esc_html__('Overlay Color', 'photomentor'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .grid-item-overlay' => 'background-color: {{VALUE}};'
				],
				'condition' => [
					'overlay_status' => 'yes'
				]
			]
		);
		
		$this->add_control(
			'control_divider_13',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);
		
		$this->add_control(
			'buttons_color',
			[
				'label' => esc_html__('Buttons Color', 'photomentor'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .grid-item-controls a' => 'color: {{VALUE}};'
				]
			]
		);
		
		$this->add_control(
			'control_divider_14',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'buttons_hovre',
			[
				'label' => esc_html__('Buttons Hover Color', 'photomentor'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .grid-item-controls a:hover' => 'color: {{VALUE}};'
				]
			]
		);
		
		$this->end_controls_section();
		
		// -------------------------------------------- //
		// ---------- Notify Button Settings ---------- //
		// -------------------------------------------- //
		$this->start_controls_section(
			'section_button_settings',
			[
				'label' => esc_html__('Notify Button Settings', 'photomentor'),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'notify_status' => 'yes'
				]
			]
		);
		
		$this->add_control(
			'notify_button_text',
			[
				'label' => esc_html__('Button Text', 'photomentor'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('Notify Photographer', 'photomentor')
			]
		);
		
		$this->add_control(
			'control_divider_15',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'notify_button_typography',
				'label' => esc_html__('Notify Button Typography', 'photomentor'),
				'selector' => '{{WRAPPER}} .photomentor_photo_proofing_notified',
				'condition' => [
					'title_status' => 'yes'
				]
			]
		);
		
		$this->add_control(
			'control_divider_16',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->start_controls_tabs('button_settings_tabs');
		
		// ------ Normal Tab ------ //
		$this->start_controls_tab(
			'button_normal_tab',
			[
				'label' => esc_html__( 'Normal', 'photomentor' ),
			]
		);
		
		$this->add_control(
			'button_color',
			[
				'label' => esc_html__('Button Color', 'photomentor'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .photomentor_photo_proofing_notified' => 'color: {{VALUE}};'
				]
			]
		);
		
		$this->add_control(
			'control_divider_17',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'button_bg_color',
			[
				'label' => esc_html__('Button Background Color', 'photomentor'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .photomentor_photo_proofing_notified' => 'background-color: {{VALUE}};'
				]
			]
		);
		
		$this->add_control(
			'control_divider_18',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'button_border',
				'placeholder' => '1px',
				'default' => '1px',
				'selector' => '{{WRAPPER}} .photomentor_photo_proofing_notified'
			]
		);
		
		$this->end_controls_tab();
		
		// ------ Hover Tab ------ //
		$this->start_controls_tab(
			'button_hover_tab',
			[
				'label' => esc_html__( 'Hover', 'photomentor' ),
			]
		);
		
		$this->add_control(
			'button_hover',
			[
				'label' => esc_html__('Button Hover Color', 'photomentor'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .photomentor_photo_proofing_notified:hover' => 'color: {{VALUE}};'
				]
			]
		);
		
		$this->add_control(
			'control_divider_19',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'button_bg_hover',
			[
				'label' => esc_html__('Button Hover Background Color', 'photomentor'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .photomentor_photo_proofing_notified:hover' => 'background-color: {{VALUE}};'
				]
			]
		);
		
		$this->add_control(
			'control_divider_20',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'button_hover_border',
				'placeholder' => '1px',
				'default' => '1px',
				'selector' => '{{WRAPPER}} .photomentor_photo_proofing_notified:hover'
			]
		);
		
		$this->end_controls_tab();
		
		$this->end_controls_tabs();
		
		$this->add_control(
			'button_align',
			[
				'label' => esc_html__('Button Alignment', 'photomentor'),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'photomentor' ),
						'icon' => 'eicon-h-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'photomentor' ),
						'icon' => 'eicon-h-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'photomentor' ),
						'icon' => 'eicon-h-align-right',
					]
				],
				'default' => 'center',
				'selectors' => [
					'{{WRAPPER}} .photomentor_photo_proofing_notified_wrapper' => 'text-align: {{VALUE}};'
				]
			]
		);
		
		$this->add_control(
			'control_divider_21',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'button_padding',
			[
				'label' => esc_html__('Button Padding', 'photomentor'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .photomentor_photo_proofing_notified' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				],
				'separator' => 'before'
			]
		);
		
		$this->add_control(
			'control_divider_22',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'button_margin',
			[
				'label' => esc_html__('Button Margin', 'photomentor'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .photomentor_photo_proofing_notified' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);
		
		$this->add_control(
			'control_divider_23',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);
		
		$this->add_control(
			'button_border_radius',
			[
				'label' => esc_html__('Button Border Radius', 'photomentor'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .photomentor_photo_proofing_notified' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);
		
		$this->add_control(
			'control_divider_24',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);
		
		$this->add_control(
			'message_status',
			[
				'label' => esc_html__('Message', 'photomentor'),
				'description' => esc_html__('Message After Email Send', 'photomentor'),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'label_on' => esc_html__( 'Show', 'photomentor' ),
				'label_off' => esc_html__( 'Hide', 'photomentor' )
			]
		);
		
		$this->add_control(
			'control_divider_25',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'message_text',
			[
				'label' => esc_html__('Message Text', ''),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('Done! Thank You!', 'photomentor'),
				'condition' => [
					'message_status' => 'yes'
				]
			]
		);
		
		$this->add_control(
			'control_divider_26',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Message Typography', 'photomentor'),
				'name' => 'message_typography',
				'selector' => '{{WRAPPER}} .photomentor_photo_proofing_notified_message',
				'condition' => [
					'message_status' => 'yes'
				]
			]
		);
		
		$this->add_control(
			'control_divider_27',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'message_color',
			[
				'label' => esc_html__('Message Color', 'photomentor'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .photomentor_photo_proofing_notified_message' => 'color: {{VALUE}};'
				],
				'condition' => [
					'message_status' => 'yes'
				]
			]
		);
		
		$this->end_controls_section();
	}
	
	protected function render() {
		$settings = $this->get_settings();
		
		$media_grid_items = $settings['media_grid_items'];
		$columns = $settings['columns'];
		$filter_status = $settings['filter_status'];
		$title_status = $settings['title_status'];
		$overlay_status = $settings['overlay_status'];
		$download_button_status = $settings['download_button_status'];
		$notify_status = $settings['notify_status'];
		$notify_email = $settings['notify_email'];
		$notify_button_text = $settings['notify_button_text'];
		$message_status = $settings['message_status'];
		$image_size_status = $settings['image_size_status'];
		
		if ($message_status == 'yes') {
			$message_text = $settings['message_text'];
		} else {
			$message_text = '';
		}
		
		if ($image_size_status == 'yes') {
			$image_width = $settings['image_width'];
			$image_height = '';
		} else {
			$image_width = 960;
			$image_height = '';
		}
		
		$uniqid = $this->get_id();
		$grid_array = array();
		$img_array = array();
		$imgCounter = 0;
		
		// ------------------------------------ //
		// ---------- Widget Content ---------- //
		// ------------------------------------ //
		if (empty($media_grid_items)) {
			return;
		}

        /* Customizer Lightbox Settings*/
        $lightbox_overlay = get_theme_mod('photomentor_lightbox_overlay', '0.7');
        $caption_state = get_theme_mod('photomentor_lightbox_title', 'none');
        $caption_padding_top = get_theme_mod('photomentor_lightbox_padding-top', '14');
        $caption_padding_bottom = get_theme_mod('photomentor_lightbox_padding-bottom', '14');
        $caption_font_size = get_theme_mod('photomentor_lightbox_font-size', '16');
        if (get_theme_mod('photomentor_lightbox_uppercase', false)) {
            $caption_uppercase = 'yes';
        } else {
            $caption_uppercase = 'no';
        }

		?>
		
		<div class="photomentor_gallery_proofing_grid_container photomentor_proofing_cont">
			<?php
			if ($filter_status == 'yes') {
				?>
				<ul id="filters" class="photomentor_grid_filter">
					<li class="photomentor_filter-item is-checked">
						<a href="#" data-category="*">
							<?php echo esc_html__('All', 'photomentor'); ?>
						</a>
					</li>
					<li class="photomentor_filter-item approved">
						<a href="#" data-category=".approved">
							<?php echo esc_html__('Approved', 'photomentor'); ?>
						</a>
					</li>
					<li class="photomentor_filter-item unapproved">
						<a href="#" data-category=".unapproved">
							<?php echo esc_html__('Unapproved', 'photomentor'); ?>
						</a>
					</li>
					<li class="photomentor_filter-item unviewed">
						<a href="#" data-category=".unviewed">
							<?php echo esc_html__('Unviewed', 'photomentor'); ?>
						</a>
					</li>
				</ul>
				<?php
			}
			?>
			
			<div class="photomentor_grid_wrapper photomentor_photoswipe_wrapper photomentor_grid_<?php echo esc_attr($uniqid); ?>" data-uniqid="<?php echo esc_attr($uniqid); ?>" data-caption="<?php echo esc_attr($caption_state); ?>" data-caption-top="<?php echo absint($caption_padding_top); ?>" data-caption-bottom="<?php echo absint($caption_padding_bottom); ?>" data-caption-size="<?php echo absint($caption_font_size); ?>" data-caption-uppercase="<?php echo esc_attr($caption_uppercase); ?>" data-overlay="<?php echo esc_attr($lightbox_overlay); ?>">
				<div class="photomentor_grid_inner photomentor_proofing_grid photomentor_gal_media_proofing_masonry_isotope_trigger isotope_filtering photomentor_columns_<?php echo esc_attr($columns); ?>">
					<?php
					$i = 0;
					
					foreach ($media_grid_items as $item) {
						$slide_type = $item['slide_type'];
						$video_url = $item['video_url'];
						$slide_image = $item['slide_image'];
						$slide_thmb = $item['slide_thmb'];
						$slide_caption_type = $item['slide_caption_type'];
						$slide_caption = $item['slide_caption'];
						
						$photoTitle = '';
						$photoAlt = '';
						
						if ($slide_type == 'image') {
							$attach_meta = photomentor_get_attachment($slide_image['id']);
							
							$img_meta = wp_get_attachment_metadata($slide_image['id']);
							$img_original_width = $img_meta['width'];
							$img_original_height = $img_meta['height'];
							
							$featured_image = wp_get_attachment_url($slide_image['id']);
							$thumb_image = aq_resize(esc_url($featured_image), esc_attr($image_width), esc_attr($image_height), true, true, true);
							$slide_img_id = $slide_image['id'];
						}
						
						if ($slide_type == 'video') {
							$img_original_width = 0;
							$img_original_height = 0;
							$attach_meta = photomentor_get_attachment($slide_thmb['id']);
							$featured_image = wp_get_attachment_url($slide_thmb['id']);
							$thumb_image = aq_resize(esc_url($featured_image), esc_attr($image_width), esc_attr($image_height), true, true, true);
							$slide_img_id = $slide_thmb['id'];
						}
						
                        $photoCaption = '';
						if (!empty($attach_meta)) {
							$photoTitle = $attach_meta['caption'];
							$photoAlt = $attach_meta['alt'];

                            if ($caption_state == 'title') {
                                $photoCaption = $attach_meta['title'];
                            }                        
                            if ($caption_state == 'caption') {
                                $photoCaption = $attach_meta['caption'];
                            }
                            if ($caption_state == 'description') {
                                $photoCaption = $attach_meta['description'];
                            }
                            if ($photoCaption !== '') {
                                $PCREpattern = '/\r\n|\r|\n/u';
                                $photoCaption = preg_replace($PCREpattern, '', nl2br($photoCaption));
                            }                        

						}
						
						if ($slide_caption_type == 'custom') {
							$photoTitle = $slide_caption;
                            if ($caption_state !== 'none') {
                                $photoCaption = $slide_caption;
                            }  
						}
						
						$img_array['attach_id'] = esc_attr($slide_img_id);
						$img_array['slide_type'] = $slide_type;
						$img_array['title'] = esc_attr($photoTitle);
						$img_array['alt'] = esc_attr($photoAlt);
						$img_array['thmb'] = esc_url($thumb_image);
						
						if ($slide_type == 'video') {
							$img_array['url'] = esc_url($video_url);
						} else {
							$img_array['url'] = esc_url($featured_image);
						}
						
						$img_array['count'] = esc_attr($imgCounter);
						$img_array['size'] = esc_attr($img_original_width) .'x'. esc_attr($img_original_height);
						
						$imgCounter++;
						
						array_push($grid_array, $img_array);
						
						$photoTitle = '';
						$photoTitle = $grid_array[$i]['title'];
						
						if (isset($photoTitle) && $photoTitle !== '') {
							$photoTitle = str_replace('"', "'", $photoTitle);
						}
						
						$photoAlt = $grid_array[$i]['alt'];
						$imgCounter = $grid_array[$i]['count'];
						$featured_image = $grid_array[$i]['url'];
						$img_thmb = $grid_array[$i]['thmb'];
						$slide_type = $grid_array[$i]['slide_type'];
						$img_video_class = '';
						
						
						
						if ($slide_type == 'video') {
							$img_video_class = 'photomentor_pswp_video_slide';
						}
						
						$photomentor_photo_proofing = get_option('photomentor_photo_proofing');
						if (!isset($photomentor_photo_proofing) || !empty($photomentor_photo_proofing)) {
							add_option('photomentor_photo_proofing');
						}
						
						$proofing_class = 'unviewed';
						$approved_btn = 'pm-icon-ok-circled';
						$unapproved_btn = 'pm-icon-cancel-circled';
						
						if (isset($photomentor_photo_proofing[$uniqid][$item['_id']]) && $photomentor_photo_proofing[$uniqid][$item['_id']] == 'approve') {
							$proofing_class = 'approved';
							$approved_btn = 'pm-icon-minus-circled';
						}
						if (isset($photomentor_photo_proofing[$uniqid][$item['_id']]) && $photomentor_photo_proofing[$uniqid][$item['_id']] == 'unapprove') {
							$proofing_class = 'unapproved';
							$unapproved_btn = 'pm-icon-minus-circled';
						}
						
						?>
						
						<div class="grid-item grid-item-proofing element load_anim_grid anim_el2 grid_b2p <?php echo esc_attr($proofing_class); ?>">
							<div class="grid-item-inner">
								<div class="photomentor_proofing_grid_item">
									<img src="<?php echo esc_url($img_thmb); ?>" alt="<?php echo esc_attr($photoAlt); ?>" class="grid_thmb"/>
									
									<?php
									if ($title_status == 'yes') {
										?>
										<div class="grid-item-content">
											<h4><?php echo esc_attr($photoTitle); ?></h4>
										</div>
										<?php
									}
									
									if ($overlay_status == 'yes') {
										?>
										<div class="grid-item-overlay"></div>
										<?php
									}
									?>
									
									<div class="grid-item-controls">
										<a class="photomentor_pswp_slide <?php echo esc_attr($img_video_class); ?> grid-item-button-zoom" href="<?php echo esc_url($featured_image); ?>" data-elementor-open-lightbox="no" data-size="<?php echo esc_attr($grid_array[$i]['size']); ?>" data-count="<?php echo esc_attr($i); ?>" data-caption="<?php echo esc_attr($photoCaption); ?>"><i class="pm-icon-search"></i></a>
										
										<?php
										if ($download_button_status == 'yes') {
											?>
											<a class="grid-item-button-download" download href="<?php echo esc_url($featured_image); ?>" data-elementor-open-lightbox="no"><i class="pm-icon-download"></i></a>
											<?php
										}
										?>
										
										<a class="grid-item-button-unapprove" data-moduleid="<?php echo esc_attr($uniqid); ?>" data-imgid="<?php echo esc_attr($item['_id']); ?>" href="<?php echo esc_js("javascript:void(0)"); ?>"><i class="<?php echo esc_attr($unapproved_btn); ?>"></i></a>
										
										<a class="grid-item-button-approve" data-moduleid="<?php echo esc_attr($uniqid); ?>" data-imgid="<?php echo esc_attr($item['_id']); ?>" href="<?php echo esc_js("javascript:void(0)"); ?>"><i class="<?php echo esc_attr($approved_btn); ?>"></i></a>
									</div>
									
									<div class="grid-icon-state grid-icon-approve"><i class="pm-icon-ok"></i></div>
									<div class="grid-icon-state grid-icon-unaprove"><i class="pm-icon-cancel"></i></div>
								</div>
							</div>
						</div>
						<?php
						
						unset($grid_array[$i]);
						$i++;
					}
					?>
				</div>
				
				<?php
				if ($notify_status == 'yes') {
					?>
					<div class="photomentor_photo_proofing_notified_wrapper">
						<a href="<?php echo esc_js("javascript:void(0)"); ?>" data-email="<?php echo esc_attr($notify_email); ?>" data-message="<?php echo esc_attr($message_text); ?>" class="photomentor_photo_proofing_notified"><?php echo esc_html($notify_button_text); ?></a>
						<h5 class="photomentor_photo_proofing_notified_message <?php echo (($message_status == 'yes') ? '' : 'photomentor_hidden_container'); ?>"></h5>
					</div>
					<?php
				}
				?>
			</div>
		</div>
		<?php
	}
	
	protected function content_template() {}
	
	public function render_plain_content() {}
}

