<?php
/*
 * Created by Pixel-Mafia
 * www.pixel-mafia.com
*/

namespace Photomentor\Core\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Photomentor_Gallery_Ken_Burns_Widget extends Widget_Base {
	
	public function get_name() {
		return 'photomentor-gallery-kenburns';
	}
	
	public function get_title() {
		return esc_html__('Gallery Ken Burns', 'photomentor');
	}
	
	public function get_icon() {
		return 'eicon-image';
	}
	
	public function get_categories() {
		return ['photomentor_gallery_widgets'];
	}
	
	public function get_script_depends() {
		return ['gallery_kenburns'];
	}
	
	protected function _register_controls() {
		
		// ----------------------------- //
		// ---------- Content ---------- //
		// ----------------------------- //
		$this->start_controls_section(
			'section_gallery',
			[
				'label' => esc_html__('Gallery', 'photomentor')
			]
		);
		
		$this->add_control(
			'images',
			[
				'label' => __( 'Add Images', 'photomentor' ),
				'type' => Controls_Manager::GALLERY,
				'default' => [],
			]
		);
		
		$this->add_control(
			'control_divider_0',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);
		
		$this->add_control(
			'module_height_state',
			[
				'label' => esc_html__('Module Height Type', 'photomentor'),
				'type' => Controls_Manager::SELECT,
				'default' => 'screen_height',
				'options' => [
					'auto' => esc_html__('Auto', 'photomentor'),
					'screen_height' => esc_html__('Screen Height', 'photomentor'),
					'custom' => esc_html__('Custom', 'photomentor')
				]
			]
		);
		
		$this->add_control(
			'control_divider_1',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'module_height_state' => 'custom'
				]
			]
		);
	
		$this->add_control(
			'module_height',
			[
				'label' => esc_html__('Module Height', 'photomentor'),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 750,
					'unit' => 'px'
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 2000
					]
				],
				'condition' => [
					'module_height_state' => 'custom'
				]
			]
		);
		
		$this->add_control(
			'control_divider_4',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);
		
		$this->add_control(
			'display_time',
			[
				'label' => esc_html__('Display Time', 'photomentor'),
				'type' => Controls_Manager::NUMBER,
				'default' => 5000,
				'min' => 0,
				'step' => 100
			]
		);
		
		$this->add_control(
			'control_divider_5',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'fade_time',
			[
				'label' => esc_html__('Fade Time', 'photomentor'),
				'type' => Controls_Manager::NUMBER,
				'default' => 1000,
				'min' => 0,
				'step' => 50
			]
		);
		
		$this->add_control(
			'control_divider_6',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'zoom_value',
			[
				'label' => esc_html__('Zoom', 'photomentor'),
				'type' => Controls_Manager::NUMBER,
				'default' => 1.2,
				'min' => 0,
				'step' => 0.1
			]
		);
		
		$this->end_controls_section();
	}
	
	protected function render() {
		$settings = $this->get_settings();
		
		$images = $settings['images'];
		
		$display_time = $settings['display_time'];
		$fade_time = $settings['fade_time'];
		$zoom_value = $settings['zoom_value'];
		$module_height_state = $settings['module_height_state'];
		$module_height = $settings['module_height']['size'];
		
		// ------------------------------------ //
		// ---------- Widget Content ---------- //
		// ------------------------------------ //
		if (empty($images)) {
			return;
		}
		
		$uniqid = mt_rand(0, 9999);
		?>
		<div class="photomentor_gallery_kenburns_container">
				<?php
				if ($module_height_state == 'auto') {
					?>
			<div class="photomentor_css_kenburns photomentor_module_loading auto_height photomentor_css_kenburns<?php echo esc_attr($uniqid); ?>" data-id="<?php echo $uniqid; ?>" data-time="<?php echo esc_attr($display_time); ?>" data-zoom="<?php echo esc_attr($zoom_value); ?>" data-fade="<?php echo esc_attr($fade_time); ?>">
					<?php
				}
				
				else if ($module_height_state == 'screen_height') {
					?>
			<div class="photomentor_css_kenburns photomentor_module_loading screen_height photomentor_css_kenburns<?php echo esc_attr($uniqid); ?>" data-id="<?php echo $uniqid; ?>" data-time="<?php echo esc_attr($display_time); ?>" data-zoom="<?php echo esc_attr($zoom_value); ?>" data-fade="<?php echo esc_attr($fade_time); ?>">
					<?php
				}
				
				else {
					?>
			<div class="photomentor_css_kenburns photomentor_module_loading photomentor_css_kenburns<?php echo esc_attr($uniqid); ?>" style="height: <?php echo esc_attr($module_height); ?>px;" data-id="<?php echo $uniqid; ?>" data-time="<?php echo esc_attr($display_time); ?>" data-zoom="<?php echo esc_attr($zoom_value); ?>" data-fade="<?php echo esc_attr($fade_time); ?>">
					<?php
				}
				$count = 0;
				$fx_counter = 0;
		
				foreach ( $images as $index => $image ) {
					$count++;
					$fx_counter++;
					if ($fx_counter == 1) {
						$fx_class = 'move_top';
					}
					if ($fx_counter == 2) {
						$fx_class = 'move_left';
					}
					if ($fx_counter == 3) {
						$fx_class = 'move_right';
					}
					if ($fx_counter == 4) {
						$fx_class = 'move_bottom';
					}
					if ($fx_counter > 4) {
						$fx_counter = 0;
					}
					$slide_image = wp_get_attachment_url($image['id']);
					
					if(($count % 2) == 0){
						$slide_class = "slide_zoom_out";
					} else {
						$slide_class = "slide_zoom_in";
					}
					?>
					<div class="photomentor_css_kenburns_slide <?php echo esc_attr($fx_class); ?> <?php echo esc_attr($slide_class); ?>" data-count="<?php echo esc_attr($count); ?>" style="background: url('<?php echo esc_url($slide_image); ?>')"></div>
					<?php
				}
				?>
			</div>
		</div>
		<?php
	}
	
	protected function content_template() {}
	
	public function render_plain_content() {}
}

