<?php
/*
 * Created by Pixel-Mafia
 * www.pixel-mafia.com
*/

namespace Photomentor\Core\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\REPEATER;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Photomentor_Gallery_Grid_Filtered_Widget extends Widget_Base {
	
	public function get_name() {
		return 'photomentor-gallery-grid-filter';
	}
	
	public function get_title() {
		return esc_html__('Grid with Filter', 'photomentor');
	}
	
	public function get_icon() {
		return 'eicon-gallery-grid';
	}
	
	public function get_categories() {
		return ['photomentor_gallery_widgets'];
	}
	
	public function get_script_depends() {
		return ['gallery_grid_filter'];
	}
	
	protected function _register_controls() {
		
		// ----------------------------- //
		// ---------- Content ---------- //
		// ----------------------------- //
		$this->start_controls_section(
			'section_gallery',
			[
				'label' => esc_html__('Gallery', 'photomentor')
			]
		);
		
		$repeater = new Repeater();
		
		$repeater->start_controls_tabs('slide_options');
		
        $repeater->add_control(
            'category_title',
            [
                'label' => esc_html__('Title', 'photomentor'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'placeholder' => 'Category Title',
                'default' => '',
            ]
        );

		$repeater->add_control(
			'category_images',
			[
				'label' => esc_html__( 'Add Images', 'photomentor' ),
				'type' => Controls_Manager::GALLERY,
				'default' => [],
			]
		);
		
		$this->add_control(
			'category_item',
			[
				'label' => 'Add Filter Categories:',
				'type' => Controls_Manager::REPEATER,
                'title_field' => '{{{ category_title }}}',
				'fields' => $repeater->get_controls(),
			]
		);
		
		$this->add_control(
			'control_divider_1',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'posts_per_page',
			[
				'label' => esc_html__('Images on Start', 'photomentor'),
				'type' => Controls_Manager::NUMBER,
				'default' => 9,
				'min' => 1,
				'step' => 1,
			]
		);
		
		$this->add_control(
			'control_divider_2',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'posts_per_click',
			[
				'label' => esc_html__('Images per Click', 'photomentor'),
				'type' => Controls_Manager::NUMBER,
				'default' => 3,
				'min' => 1,
				'step' => 1,
				'condition' => [
					'more_button_status' => 'show'
				]
			]
		);
		
		$this->add_control(
			'control_divider_3',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'columns',
			[
				'label' => esc_html__('Columns', 'photomentor'),
				'type' => Controls_Manager::SELECT,
				'default' => 3,
				'options' => [
					1 => esc_html__('One', 'photomentor'),
					2 => esc_html__('Two', 'photomentor'),
					3 => esc_html__('Three', 'photomentor'),
					4 => esc_html__('Four', 'photomentor'),
					5 => esc_html__('Five', 'photomentor')
				]
			]
		);
		
		$this->add_control(
			'control_divider_4',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);
		
		$this->add_control(
			'more_button_status',
			[
				'label' => esc_html__('Load More Button', 'photomentor'),
				'type' => Controls_Manager::SELECT,
				'default' => 'show',
				'options' => [
					'show' => esc_html__('Show', 'photomentor'),
					'hide' => esc_html__('Hide', 'photomentor')
				]
			]
		);
		
		$this->add_control(
			'control_divider_5',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'more_button_text',
			[
				'label' => esc_html__('More Button Text', 'photomentor'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('Load More', 'photomentor'),
				'condition' => [
					'more_button_status' => 'show'
				]
			]
		);
		
		$this->end_controls_section();
		
		// -------------------------------------- //
		// ---------- Gallery Settings ---------- //
		// -------------------------------------- //
		$this->start_controls_section(
			'section_gallery_settings',
			[
				'label' => esc_html__('Gallery Settings', 'photomentor'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_control(
			'image_size_status',
			[
				'label' => esc_html__('Image Custom Size', 'photomentor'),
				'type' => Controls_Manager::POPOVER_TOGGLE,
				'return_value' => 'yes'
			]
		);
		
		$this->start_popover();
		
		$this->add_control(
			'image_width',
			[
				'label' => esc_html__('Image Width', 'photomentor'),
				'type' => Controls_Manager::NUMBER,
				'default' => 960,
				'min' => 1,
				'condition' => [
					'image_size_status' => 'yes'
				]
			]
		);
		
		$this->add_control(
			'control_divider_6',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'image_height',
			[
				'label' => esc_html__('Image Height', 'photomentor'),
				'type' => Controls_Manager::NUMBER,
				'default' => 960,
				'min' => 1,
				'condition' => [
					'image_size_status' => 'yes'
				]
			]
		);
		
		$this->end_popover();
		
		$this->add_control(
			'control_divider_7',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'items_padding',
			[
				'label' => esc_html__('Spaces Between Items', 'photomentor'),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200
					]
				],
				'selectors' => [
					'{{WRAPPER}} .photomentor_gallery_item' => 'padding: 0 0 {{SIZE}}{{UNIT}} {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .photomentor_grid_inner' => 'margin-left: -{{SIZE}}{{UNIT}};'
				]
			]
		);
		
		$this->add_control(
			'control_divider_8',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'items_radius',
			[
				'label' => esc_html__('Items Border Radius', 'photomentor'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .grid-item-inner a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);
		
		$this->add_control(
			'control_divider_9',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'hover_type',
			[
				'label' => esc_html__('Hover Type', 'photomentor'),
				'type' => Controls_Manager::SELECT,
				'default' => 'gradient_caption',
				'options' => [
					'kenburns_effect' => esc_html__('Kenburns Effect', 'photomentor'),
					'kenburns_with_caption' => esc_html__('Kenburns with Caption', 'photomentor'),
					'gloss' => esc_html__('Gloss', 'photomentor'),
					'gradient_caption' => esc_html__('Gradient with Caption', 'photomentor'),
					'solid_plus' => esc_html__('Plus at Bottom', 'photomentor'),
					'caption' => esc_html__('Overlay with Caption', 'photomentor'),
					'magnifier' => esc_html__('Overlay with Magnifier', 'photomentor'),
					'plus' => esc_html__('Overlay with Plus', 'photomentor'),
					'overlay' => esc_html__('Just Overlay', 'photomentor'),
					'none' => esc_html__('No Hover', 'photomentor')
				]
			]
		);
		
		$this->add_control(
			'control_divider_10',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'hover_type!' => ['gloss', 'gradient_caption', 'none']
				]
			]
		);
		
		$this->add_control(
			'overlay_color',
			[
				'label' => esc_html__('Overlay Color', 'photomentor'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .grid-item-overlay' => 'background-color: {{VALUE}};'
				],
				'condition' => [
					'hover_type!' => ['gloss', 'gradient_caption', 'none']
				]
			]
		);
		
		$this->add_control(
			'control_divider_11',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'hover_type' => ['gradient_caption', 'caption']
				]
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'caption_typography',
				'label' => esc_html__('Caption Typography', 'photomentor'),
				'selector' => '{{WRAPPER}} .grid-item-content h4',
				'condition' => [
					'hover_type' => ['gradient_caption', 'caption']
				]
			]
		);
		
		$this->add_control(
			'control_divider_12',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'hover_type' => ['gradient_caption', 'caption']
				]
			]
		);
		
		$this->add_control(
			'caption_color',
			[
				'label' => esc_html__('Caption Color', 'photomentor'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .grid-item-content h4' => 'color: {{VALUE}};'
				],
				'condition' => [
					'hover_type' => ['gradient_caption', 'caption']
				]
			]
		);
		
		$this->add_control(
			'control_divider_13',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'hover_type' => ['solid_plus', 'magnifier', 'plus']
				]
			]
		);
		
		$this->add_control(
			'marker_color',
			[
				'label' => esc_html__('Marker Color', 'photomentor'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .hover_type_solid_plus .grid-item-overlay:before, {{WRAPPER}} .hover_type_plus .grid-item-overlay:before, {{WRAPPER}} .hover_type_solid_plus .grid-item-overlay:after, {{WRAPPER}} .hover_type_plus .grid-item-overlay:after' => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .hover_type_magnifier .grid-item-overlay:before' => 'color: {{VALUE}};'
					
				],
				'condition' => [
					'hover_type' => ['solid_plus', 'magnifier', 'plus']
				]
			]
		);
		
		$this->end_controls_section();

		// ----------------------------------------------- //
		// --------------- Filter Settings --------------- //
		// ----------------------------------------------- //
		$this->start_controls_section(
			'section_filter_settings',
			[
				'label' => esc_html__('Filter Settings', 'photomentor'),
				'tab' => Controls_Manager::TAB_STYLE
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'filter_typography',
				'label' => esc_html__('Filter Typography', 'photomentor'),
				'selector' => '{{WRAPPER}} .photomentor_grid_filter a'
			]
		);
		
		$this->add_control(
			'control_divider_14f',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);
		
		$this->add_control(
			'filter_spacing',
			[
				'label' => esc_html__('Filter Spacing', 'photomentor'),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100
					]
				],
                'default' => [
                    'unit' => 'px',
                    'size' => '0'
                ],
				'selectors' => [
					'{{WRAPPER}} .photomentor_grid_filter' => 'margin-bottom: {{SIZE}}{{UNIT}};'
				]
			]
		);
		
		$this->add_control(
			'control_divider_18f',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'filter_margin',
			[
				'label' => esc_html__('Filter Items Spacing', 'photomentor'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .photomentor_grid_filter li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);
		
		$this->add_control(
			'control_divider_17f',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);

		$this->add_control(
			'filter_inner_padding',
			[
				'label' => esc_html__('Filter Items Padding', 'photomentor'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .photomentor_grid_filter a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);
		
		$this->add_control(
			'control_divider_19f',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);
			
		$this->add_control(
			'filter_align',
			[
				'label' => esc_html__('Filter Alignment', 'photomentor'),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'photomentor' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'photomentor' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'photomentor' ),
						'icon' => 'eicon-text-align-right',
					]
				],
				'default' => 'center',
				'selectors' => [
					'{{WRAPPER}} .photomentor_grid_filter' => 'text-align: {{VALUE}};'
				]
			]
		);
		
		$this->add_control(
			'control_divider_21f',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);

        $this->start_controls_tabs('filter_color_settings');

        $this->start_controls_tab(
            'tab_filter_normal',
            [
                'label' => esc_html__('Normal', 'photomentor')
            ]
        );

		$this->add_control(
			'filter_color_normal',
			[
				'label' => esc_html__('Item Color', 'photomentor'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .photomentor_grid_filter a' => 'color: {{VALUE}};'
				]
			]
		);

		$this->add_control(
			'filter_bg_normal',
			[
				'label' => esc_html__('Background Color', 'photomentor'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .photomentor_grid_filter a' => 'background-color: {{VALUE}};'
				]
			]
		);

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_filter_hover',
            [
                'label' => esc_html__('Hover', 'photomentor')
            ]
        );

		$this->add_control(
			'filter_color_hover',
			[
				'label' => esc_html__('Item Hover Color', 'photomentor'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .photomentor_grid_filter a:hover' => 'color: {{VALUE}};'
				]
			]
		);

		$this->add_control(
			'filter_bg_hover',
			[
				'label' => esc_html__('Background Hover Color', 'photomentor'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .photomentor_grid_filter a:hover' => 'background-color: {{VALUE}};'
				]
			]
		);

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_filter_active',
            [
                'label' => esc_html__('Active', 'photomentor')
            ]
        );

		$this->add_control(
			'filter_color_active',
			[
				'label' => esc_html__('Item Active Color', 'photomentor'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .photomentor_grid_filter li.is-checked a' => 'color: {{VALUE}};'
				]
			]
		);

		$this->add_control(
			'filter_bg_active',
			[
				'label' => esc_html__('Background Active Color', 'photomentor'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .photomentor_grid_filter li.is-checked a' => 'background-color: {{VALUE}};'
				]
			]
		);

        $this->end_controls_tab();

        $this->end_controls_tabs();
        
		$this->end_controls_section();
    
		// ----------------------------------------------- //
		// ---------- Load More Button Settings ---------- //
		// ----------------------------------------------- //
		$this->start_controls_section(
			'section_more_button_settings',
			[
				'label' => esc_html__('Load More Button Settings', 'photomentor'),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'more_button_status' => 'show'
				]
			]
		);
		
		$this->start_controls_tabs('more_button_settings_tabs');
		
		// ------ Tab Settings ------ //
		$this->start_controls_tab(
			'tab_button_settings',
			[
				'label' => esc_html__('Settings', 'photomentor')
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'more_button_typography',
				'label' => esc_html__('Button Typography', 'photomentor'),
				'selector' => '{{WRAPPER}} .photomentor_load_more_button'
			]
		);
		
		$this->add_control(
			'more_button_icon_status',
			[
				'label' => esc_html__('Button Icon', 'photomentor'),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'no',
				'label_off' => esc_html__('Off', 'photomentor'),
				'label_on' => esc_html__('On', 'photomentor'),
				'separator' => 'before'
			]
		);
		
		$this->add_control(
			'control_divider_14',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'more_button_icon_status' => 'yes'
				]
			]
		);
		
		$this->add_control(
			'more_button_icon',
			[
				'label' => esc_html__('Choose Icon', 'photomentor'),
				'type' => Controls_Manager::ICON,
				'label_block' => true,
				'default' => 'fa fa-long-arrow-right',
				'condition' => [
					'more_button_icon_status' => 'yes'
				]
			]
		);
		
		$this->add_control(
			'control_divider_15',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'more_button_icon_status' => 'yes'
				]
			]
		);
		
		$this->add_control(
			'more_button_icon_position',
			[
				'label' => esc_html__('Button Icon Position', 'photomentor'),
				'type' => Controls_Manager::SELECT,
				'default' => 'after',
				'options' => [
					'after' => esc_html__('After Text', 'photomentor'),
					'before' => esc_html__('Before Text', 'photomentor')
				],
				'condition' => [
					'more_button_icon_status' => 'yes'
				]
			]
		);
		
		$this->add_control(
			'control_divider_16',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'more_button_icon_status' => 'yes',
					'more_button_icon_position' => 'after'
				]
			]
		);
		
		$this->add_control(
			'more_button_icon_margin_left',
			[
				'label' => esc_html__('Space Before Icon', 'photomentor'),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 50
					]
				],
				'selectors' => [
					'{{WRAPPER}} .photomentor_more_button_icon' => 'margin-left: {{SIZE}}{{UNIT}};'
				],
				'condition' => [
					'more_button_icon_status' => 'yes',
					'more_button_icon_position' => 'after'
				]
			]
		);
		
		$this->add_control(
			'control_divider_17',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'more_button_icon_status' => 'yes',
					'more_button_icon_position' => 'before'
				]
			]
		);
		
		$this->add_control(
			'more_button_icon_margin_right',
			[
				'label' => esc_html__('Space After Icon', 'photomentor'),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 50
					]
				],
				'selectors' => [
					'{{WRAPPER}} .photomentor_more_button_icon' => 'margin-right: {{SIZE}}{{UNIT}};'
				],
				'condition' => [
					'more_button_icon_status' => 'yes',
					'more_button_icon_position' => 'before'
				]
			]
		);
		
		$this->add_control(
			'more_button_padding',
			[
				'label' => esc_html__('Button Padding', 'photomentor'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .photomentor_load_more_button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				],
				'separator' => 'before'
			]
		);
		
		$this->add_control(
			'control_divider_18',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'more_button_margin',
			[
				'label' => esc_html__('Button Margin', 'photomentor'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .photomentor_load_more_button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);
		
		$this->add_control(
			'control_divider_19',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'more_button_border_radius',
			[
				'label' => esc_html__('Button Border Radius', 'photomentor'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .photomentor_load_more_button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);
		
		$this->add_control(
			'control_divider_20',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'more_button_align',
			[
				'label' => esc_html__('Button Alignment', 'photomentor'),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'photomentor' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'photomentor' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'photomentor' ),
						'icon' => 'eicon-text-align-right',
					]
				],
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .photomentor_load_more' => 'text-align: {{VALUE}};'
				]
			]
		);
		
		$this->end_controls_tab();
		
		// ------ Tab Normal ------ //
		$this->start_controls_tab(
			'tab_more_button_normal',
			[
				'label' => esc_html__('Normal', 'photomentor')
			]
		);
		
		$this->add_control(
			'more_button_color',
			[
				'label' => esc_html__('Button Color', 'photomentor'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .photomentor_load_more_button' => 'color: {{VALUE}};'
				]
			]
		);
		
		$this->add_control(
			'control_divider_21',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'more_button_bg_color',
			[
				'label' => esc_html__('Button Background Color', 'photomentor'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .photomentor_load_more_button' => 'background-color: {{VALUE}};'
				]
			]
		);
		
		$this->add_control(
			'control_divider_22',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'more_button_border_status',
			[
				'label' => esc_html__('Button Border', 'photomentor'),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'no'
			]
		);
		
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'more_button_border',
				'placeholder' => '1px',
				'default' => '1px',
				'selector' => '{{WRAPPER}} .photomentor_load_more_button',
				'condition' => [
					'more_button_border_status' => 'yes'
				]
			]
		);
		
		$this->add_control(
			'control_divider_23',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'more_button_shadow',
				'label' => esc_html__('Button Shadow', 'photomentor'),
				'selector' => '{{WRAPPER}} .photomentor_load_more_button'
			]
		);
		
		$this->end_controls_tab();
		
		// ------ Tab Hover ------ //
		$this->start_controls_tab(
			'tab_more_button_hover',
			[
				'label' => esc_html__('Hover', 'photomentor')
			]
		);
		
		$this->add_control(
			'more_button_hover',
			[
				'label' => esc_html__('Button Hover Color', 'photomentor'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .photomentor_load_more_button:hover' => 'color: {{VALUE}};'
				]
			]
		);
		
		$this->add_control(
			'control_divider_24',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'more_button_bg_hover',
			[
				'label' => esc_html__('Button Hover Background Color', 'photomentor'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .photomentor_load_more_button:hover' => 'background-color: {{VALUE}};'
				]
			]
		);
		
		$this->add_control(
			'control_divider_25',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'more_button_hover_border',
				'placeholder' => '1px',
				'default' => '1px',
				'selector' => '{{WRAPPER}} .photomentor_load_more_button:hover'
			]
		);
		
		$this->add_control(
			'control_divider_26',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'more_button_hover_shadow',
				'label' => esc_html__('Button Shadow', 'photomentor'),
				'selector' => '{{WRAPPER}} .photomentor_load_more_button:hover'
			]
		);
		
		$this->end_controls_tab();
		
		$this->end_controls_tabs();
		
		$this->end_controls_section();
	}
	
	protected function render() {
		$settings = $this->get_settings();
		
        $categs = $settings['category_item'];
        
		$posts_per_page = $settings['posts_per_page'];
		$posts_per_click = $settings['posts_per_click'];
		$columns = $settings['columns'];
		$more_button_status = $settings['more_button_status'];
		$more_button_text = $settings['more_button_text'];
		$image_size_status = $settings['image_size_status'];
		$hover_type = $settings['hover_type'];
		$more_button_icon_status = $settings['more_button_icon_status'];
		$more_button_icon_position = $settings['more_button_icon_position'];
		$more_button_icon = $settings['more_button_icon'];
		
		if ($image_size_status == 'yes') {
			$image_width = $settings['image_width'];
			$image_height = $settings['image_height'];
		} else {
			$image_width = 960;
			$image_height = 960;
		}
		
		$uniqid = mt_rand(0, 99999);
		$grid_filter_array = array();
		$img_array = array();
		$demo_array = array();
		$imgCounter = 0;
		
        if (empty($categs)) {
            echo esc_html__("You had add no category", "photomentor");
            return;
        }
        
        /* Customizer Lightbox Settings*/
        $lightbox_overlay = get_theme_mod('photomentor_lightbox_overlay', '0.7');
        $caption_state = get_theme_mod('photomentor_lightbox_title', 'none');
        $caption_padding_top = get_theme_mod('photomentor_lightbox_padding-top', '14');
        $caption_padding_bottom = get_theme_mod('photomentor_lightbox_padding-bottom', '14');
        $caption_font_size = get_theme_mod('photomentor_lightbox_font-size', '16');
        if (get_theme_mod('photomentor_lightbox_uppercase', false)) {
            $caption_uppercase = 'yes';
        } else {
            $caption_uppercase = 'no';
        }
        
        foreach ($categs as $item) {
            // Add Category to Array
            $category_slug = strtr($item['category_title'], array(
                ' ' => '-',
                '&' => '+',
                '?' => ''
            ));
            $category_slug = strtolower($category_slug);
            $grid_filter_array[$category_slug]['title'] = $item['category_title'];
            $grid_filter_array[$category_slug]['images'] = array();
            
            foreach ( $item['category_images'] as $index => $image ) {
                //Add Category Images
                $attach_meta = photomentor_get_attachment($image['id']);
                $img_meta = wp_get_attachment_metadata($image['id']);
                $img_original_width = $img_meta['width'];
                $img_original_height = $img_meta['height'];

                $photoTitle = $attach_meta['caption'];

                $photoCaption = '';
                if ($caption_state == 'title') {
                    $photoCaption = $attach_meta['title'];
                }
                if ($caption_state == 'caption') {
                    $photoCaption = $attach_meta['caption'];
                }
                if ($caption_state == 'description') {
                    $photoCaption = $attach_meta['description'];
                }
                if ($photoCaption !== '') {
                    $PCREpattern = '/\r\n|\r|\n/u';
                    $photoCaption = preg_replace($PCREpattern, '', nl2br($photoCaption));
                }

                $photoAlt = $attach_meta['alt'];

                $featured_image = wp_get_attachment_url($image['id']);
                if (strlen($featured_image[0]) > 0) {
                    $featured_image_url = aq_resize(esc_url($featured_image), esc_attr($image_width), esc_attr($image_height), true, true, true);
                } else {
                    $featured_image_url = '';
                }

                $featured_image = wp_get_attachment_image_src($image['id'], 'original');

                $img_array['attach_id'] = esc_attr($image['id']);
                $img_array['slide_type'] = 'image';
                $img_array['title'] = esc_attr($photoTitle);
                $img_array['capt'] = esc_attr($photoCaption);
                $img_array['alt'] = esc_attr($photoAlt);
                $img_array['thmb'] = esc_url($featured_image_url);
                $img_array['url'] = esc_url($featured_image[0]);
                $img_array['count'] = esc_attr($imgCounter);
                $img_array['size'] = esc_attr($img_original_width) .'x'. esc_attr($img_original_height);

                $imgCounter++;

                array_push($grid_filter_array[$category_slug]['images'], $img_array);
            }
        }

		// ------------------------------------ //
		// ---------- Widget Content ---------- //
		// ------------------------------------ //
		?>
		
		<div class="photomentor_gallery_grid_w_filter_container">
			<div class="photomentor_grid_wrapper photomentor_photoswipe_wrapper photomentor_grid_<?php echo esc_attr($uniqid); ?> <?php echo ((get_option('photomentor_demo')) ? 'demo_mode' : ''); ?>" data-uniqid="<?php echo esc_attr($uniqid); ?>" data-firstload="<?php echo esc_attr($posts_per_page); ?>" data-perload="<?php echo esc_attr($posts_per_click); ?>" data-caption="<?php echo esc_attr($caption_state); ?>" data-caption-top="<?php echo absint($caption_padding_top); ?>" data-caption-bottom="<?php echo absint($caption_padding_bottom); ?>" data-caption-size="<?php echo absint($caption_font_size); ?>" data-caption-uppercase="<?php echo esc_attr($caption_uppercase); ?>" data-overlay="<?php echo esc_attr($lightbox_overlay); ?>">
                <ul class="photomentor_grid_filter">
                    <?php
                    $i = 0;
                    foreach ($grid_filter_array as $slug => $content) {
                        if ( $i > 0) {
                            $temp_class = 'not-loaded-yet';
                        } else {
                            $temp_class = 'is-checked';
                        }
                        echo '<li class="'. esc_attr($temp_class) .'"><a href="' . esc_js("javascript:void(0)") . '" data-category=".' . esc_attr($slug) . '">'. $content['title'] .'</a></li>';
                        $i++;
                    }
                    ?>
                </ul><!-- .photomentor_grid_filter -->
				<div class="photomentor_grid_inner photomentor_gallery_grid_isotope_trigger isotope_filtering photomentor_columns_<?php echo esc_attr($columns); ?> hover_type_<?php echo esc_attr($hover_type); ?>" data-perload="<?php echo esc_attr($posts_per_click) ?>">
					<?php
                    $counter = 0;
                    foreach ($grid_filter_array as $slug => $content) {
                        if ($counter == 0) {
                            if ($posts_per_page > count($grid_filter_array[$slug]['images'])) {
                                $posts_per_page = count($grid_filter_array[$slug]['images']);
                            }

                            $i = 0;

                            while ($i < $posts_per_page) {
                                if ($grid_filter_array[$slug]['images'][$i]['slide_type'] == 'image') {
                                    $thishref = wp_get_attachment_url($grid_filter_array[$slug]['images'][$i]['attach_id']);
                                    $thisvideoclass = '';
                                } else if ($grid_filter_array[$slug]['images'][$i]['slide_type'] == 'video') {
                                    $thishref = $grid_filter_array[$slug]['images'][$i]['src'];
                                    $thisvideoclass = 'video_zoom';
                                }
                                $photoTitle = '';
                                $photoTitle = $grid_filter_array[$slug]['images'][$i]['title'];
                                if (isset($photoTitle) && $photoTitle !== '') {
                                    $photoTitle = str_replace('"', "'", $photoTitle);
                                }
                                
                                $photoCaption = $grid_filter_array[$slug]['images'][$i]['capt'];
                                if (isset($photoCaption) && $photoCaption !== '') {
                                    $photoCaption = str_replace('"', "'", $photoCaption);
                                }
                                
                                $photoAlt = $grid_filter_array[$slug]['images'][$i]['alt'];
                                $imgCounter = $grid_filter_array[$slug]['images'][$i]['count'];
                                $featured_image = $grid_filter_array[$slug]['images'][$i]['url'];
                                $img_thmb = $grid_filter_array[$slug]['images'][$i]['thmb'];
                                ?>

                                <div class="photomentor_gallery_item grid-item element load_anim_grid anim_el2 grid_b2p <?php echo esc_attr($slug); ?>">
                                    <div class="grid-item-inner">
                                        <a class="photomentor_pswp_slide photomentor_drag_protect photomentor_dp photomentor_no_select" href="<?php echo esc_url($featured_image); ?>" data-elementor-open-lightbox="no" data-size="<?php echo esc_attr($grid_filter_array[$slug]['images'][$i]['size']); ?>" data-count="<?php echo esc_attr($i); ?>" data-caption="<?php echo esc_attr($photoCaption); ?>">
                                            <img src="<?php echo esc_url($img_thmb); ?>" alt="<?php echo esc_attr($photoAlt); ?>" class="grid_thmb"/>

                                            <div class="grid-item-content">
                                                <h4><?php echo esc_html($photoTitle); ?></h4>
                                            </div>

                                            <div class="grid-item-overlay"></div>
                                        </a>

                                        <div class="photomentor-img-preloader"></div>
                                    </div>
                                </div>
                                <?php
                                if (get_option('photomentor_demo') == 'true') {
                                    $demo_array[$i] = $grid_filter_array[$slug]['images'][$i];
                                }
                                unset($grid_filter_array[$slug]['images'][$i]);
                                $i++;
                            }
                            $counter++;
                        }
                    }

					?>
				</div>
				
				<?php
                foreach ($grid_filter_array as $slug => $content) {
                    $i = 0;
                    $grid_array = $content['images'];

                    if (isset($grid_array) && count($grid_array) > 0) {
                        ?>
                        <div class="photomentor_grid_gallery_array" data-id = "<?php echo esc_attr($uniqid); ?>" data-categ="<?php echo esc_attr($slug); ?>">
                            <?php
                            foreach ($grid_array as $image) {
                                ?>
                                <div class="photomentor_grid_filter_array_item"
                                     data-id="<?php echo esc_attr($uniqid); ?>"
                                     data-type="<?php echo esc_attr($image['slide_type']); ?>"
                                     data-img="<?php echo esc_url($image['url']); ?>"
                                     data-thmb="<?php echo esc_url($image['thmb']); ?>"
                                     data-title="<?php echo esc_attr($image['title']); ?>"
                                     data-caption="<?php echo esc_attr($image['capt']); ?>"
                                     data-alt="<?php echo esc_attr($image['alt']); ?>"
                                     data-counter="<?php echo esc_attr($image['count']); ?>"
                                     data-size="<?php echo esc_attr($image['size']); ?>"
                                ></div>
                                <?php
                            }
                            if (get_option('photomentor_demo') == 'true') {
                                foreach ($demo_array as $image) {
                                    ?>
                                    <div class="photomentor_grid_filter_array_item"
                                         data-id="<?php echo esc_attr($uniqid); ?>"
                                         data-type="<?php echo esc_attr($image['slide_type']); ?>"
                                         data-img="<?php echo esc_url($image['url']); ?>"
                                         data-thmb="<?php echo esc_url($image['thmb']); ?>"
                                         data-title="<?php echo esc_attr($image['title']); ?>"
                                         data-caption="<?php echo esc_attr($image['capt']); ?>"
                                         data-alt="<?php echo esc_attr($image['alt']); ?>"
                                         data-counter="<?php echo esc_attr($image['count']); ?>"
                                         data-size="<?php echo esc_attr($image['size']); ?>"
                                    ></div>
                                    <?php
                                }
                            }
                            ?>
                        </div>

                        <?php
                        if ($more_button_status !== 'hide') {
                            ?>
                            <div class="photomentor_load_more grid_loadmore_wrapper">
                                <a class="photomentor_load_more_button grid_load_more <?php echo (($more_button_status == 'lazy') ? 'lazy_loading' : '');?>" href="<?php echo esc_js("javascript:void(0)"); ?>" data-categ="<?php echo esc_attr($slug); ?>">
                                    <?php
                                    if ($more_button_icon_status == 'yes' && $more_button_icon_position == 'before') {
                                        ?>
                                        <i class="photomentor_more_button_icon <?php echo esc_attr($more_button_icon); ?>"></i>
                                        <?php
                                    }

                                    echo esc_html($more_button_text);

                                    if ($more_button_icon_status == 'yes' && $more_button_icon_position == 'after') {
                                        ?>
                                        <i class="photomentor_more_button_icon <?php echo esc_attr($more_button_icon); ?>"></i>
                                        <?php
                                    }
                                    ?>
                                </a>
                            </div>
                            <?php
                        }
                    }
                }
				?>
			</div>
		</div>
		<?php
	}
	
	protected function content_template() {}
	
	public function render_plain_content() {}
}
