<?php
/*
 * Created by Pixel-Mafia
 * www.pixel-mafia.com
*/

// Get Template Part
if (!function_exists('photomentor_get_template_part')) {
	function photomentor_get_template_part($photomentor_template, $photomentor_data = array()) {
		extract($photomentor_data);
		include __DIR__ . '/templates/' . $photomentor_template . '.php';
	}
}

# Get Featured Image Url
if (!function_exists('photomentor_get_featured_image_url')) {
	function photomentor_get_featured_image_url()
	{
		$featured_image_full_url = wp_get_attachment_image_src(get_post_thumbnail_id(), 'full');
		if (isset($featured_image_full_url[0]) && strlen($featured_image_full_url[0]) > 0) {
			return $featured_image_full_url[0];
		} else {
			return false;
		}
	}
}

# Get Image Meta
if (!function_exists('photomentor_get_attachment')) {
	function photomentor_get_attachment($attachment_id)
	{
		$attachment = get_post($attachment_id);
		return array(
			'alt' => get_post_meta($attachment->ID, '_wp_attachment_image_alt', true),
			'caption' => $attachment->post_excerpt,
			'description' => $attachment->post_content,
			'href' => get_permalink($attachment->ID),
			'src' => $attachment->guid,
			'title' => $attachment->post_title
		);
	}
}

# Object To Array
if (!function_exists('photomentor_objectToArray')) {
	function photomentor_objectToArray ($object) {
		if(!is_object($object) && !is_array($object))
			return $object;
		
		return array_map('photomentor_objectToArray', (array) $object);
	}
}